from ase.io import write
from ase.units import Bohr
from gpaw import restart, setup_paths
import numpy as np

basename = 'mixed'

setup_paths.insert(0, '/users/home/aes38/basissets/')

atoms, calc = restart('../mixed.gpw')

nbands = calc.get_number_of_bands()
for band in range(nbands):
    wf = calc.get_pseudo_wave_function(band=band)
    wfabs = np.abs(wf)
    wfr = wf.real
    wfi = wf.imag
    fname = f'{basename}_{band}.cube'
    print('writing wf', band, 'to file', fname)
    write(fname, atoms, data=wfabs * Bohr ** 1.5)
    write(f'real_{band}.cube', atoms, data=wfr * Bohr ** 1.5)
    write(f'imag_{band}.cube', atoms, data=wfi * Bohr ** 1.5)
