from gpaw import GPAW, FD, restart, setup_paths
from gpaw.directmin.etdm_fdpw import FDPWETDM
from gpaw.mom import prepare_mom_calculation
import numpy as np

setup_paths.insert(0, '/users/home/aes38/basissets/')

atoms, calc = restart('/users/home/aes38/Rydberg/new/ammonia/Real/fifthext/triplet.gpw', txt = 'triplet.txt')
calc.wfs.initialize_wave_functions_from_restart_file()
f_n = [calc.wfs.kpt_u[x].f_n.copy() for x in range(len(calc.wfs.kpt_u))]
psit_nG = [calc.wfs.kpt_u[x].psit_nG.copy() for x in range(len(calc.wfs.kpt_u))]

calc.set(eigensolver=FDPWETDM(excited_state=True, functional='PZ-SIC',
        maxiter_inner_loop=200, printinnerloop=True),
        maxiter=1000,
        mode=FD(force_complex_dtype=True),
        convergence={'eigenstates': 1e-6})

calc.initialize(atoms)
calc.set_positions(atoms)

for i, psit in enumerate(psit_nG):
    for k, band in enumerate(psit):
        d = np.random.rand() * 0.2
        calc.wfs.kpt_u[i].psit_nG.real[k] = np.cos(d) * band
        calc.wfs.kpt_u[i].psit_nG.imag[k] = np.sin(d) * band
    calc.wfs.kpt_u[i].f_n = f_n[i]

# prepare_mom_calculation(calc, atoms, f_n)
calc.calculate(system_changes=None)
calc.write('triplet.gpw', mode = 'all')


