from gpaw import GPAW, LCAO, setup_paths
from ase.io import read
from gpaw.directmin.etdm import ETDM
from gpaw.directmin.tools import excite
from gpaw.directmin.derivatives import Davidson
from gpaw.mixer import DummyMixer
from gpaw.xc import XC

atoms = read('../../nh3.xyz')
atoms.set_cell([20, 20, 20])
atoms.center()

mode = LCAO(force_complex_dtype=True) 
setup_paths.insert(0, '/users/home/aes38/basissets/')

calc = GPAW(mode=mode,
        basis='aug-cc-pVDZ_PBE.sz',
        h=0.15,
        xc='PBE',
        maxiter=1000,
        mixer={'backend': 'no-mixing'},
        spinpol=True,
        eigensolver=ETDM(functional_settings={'name': 'PZ-SIC', 'scaling_factor': (1.0, 1.0)),
        occupations={'name': 'fixed-uniform'},
        nbands='nao',
        symmetry='off',
        txt='ground.txt')

atoms.calc = calc
atoms.get_potential_energy()

calc.write('ground.gpw')

