from gpaw import GPAW, restart, setup_paths
from gpaw.directmin.tools import excite
from gpaw.directmin.etdm_lcao import LCAOETDM
from gpaw.mom import prepare_mom_calculation
import numpy as np

setup_paths.insert(0, '/users/home/aes38/basissets/')

atoms, calc = restart('../ground.gpw', txt = 'mixed.txt')
calc.calculate(properties=['energy'], system_changes=['positions'])

f_sn = excite(calc, 0, 3, (0, 0))

calc.set(eigensolver=LCAOETDM(excited_state=True, searchdir_algo={'name': 'l-bfgs-p_gmf'},
                              linesearch_algo={'name': 'max-step'},
                              partial_diagonalizer={'name': 'Davidson',
                                                    'logfile': 'davidson.txt',
                                                    'sp_order': 5}))

prepare_mom_calculation(calc, atoms, f_sn, use_fixed_occupations=True)

e = atoms.get_potential_energy()
calc.write('mixed.gpw', mode = 'all')

