from gpaw import GPAW, FD, setup_paths
from ase.io import read
from gpaw.directmin.fdpw.directmin import DirectMin
from gpaw.directmin.tools import excite_and_sort
from gpaw.directmin.derivatives import Davidson
from gpaw.mixer import DummyMixer
from gpaw.xc import XC

atoms = read('../../../nh3.xyz')
atoms.set_cell([20, 20, 20])
atoms.center()

# mode = FD(force_complex_dtype=True) 
setup_paths.insert(0, '/users/home/aes38/basissets/')

calc = GPAW(mode='fd',
        h=0.15,
        xc='PBE',
        maxiter=1000,
        mixer={'name': 'dummy'},
        spinpol=True,
        eigensolver=DirectMin(convergelumo=False),
        occupations={'name': 'fixed-uniform'},
        nbands=-10,
        symmetry='off',
        txt='unconverged.txt')

atoms.calc = calc
atoms.get_potential_energy()

calc.write('unconverged.gpw')

