from gpaw import restart
from gpaw.directmin.tools import excite_and_sort
from gpaw.directmin.fdpw.directmin import DirectMin
import numpy as np

atoms, calc = restart('unconverged.gpw')
calc.calculate(properties=['energy'], system_changes=['positions'])
calc.set(txt='mixedunconverged.txt')

excite_and_sort(calc.wfs, 0, 0, spin=(0, 0))

f_sn = []
for spin in range(calc.get_number_of_spins()):
    f_n = calc.get_occupation_numbers(spin=spin)
    f_sn.append(f_n)

appr_sp_order = 1

calc.set(eigensolver=DirectMin(
         partial_diagonalizer={
             'name': 'Davidson', 'logfile': 'davidsonunconv.txt', 'm': 20,
             'cap_krylov': False, 'eps': 1e-2, 'h': 1e-3, 'sp_order': appr_sp_order},
         maxiterxst=np.inf,
         xstlogfile='innerloopunconv.txt',
         #g_tolxst=1e-3,
         egdecomp=False,
         need_init_orbs=False,
         searchdir_algo={'name': 'LBFGS-P_GMF'},
         exstopt=True),
         occupations={'name': 'mom', 'numbers': f_sn,
                      'use_fixed_occupations': True})

atoms.get_potential_energy()

calc.write('mixedunconverged.gpw')

