from gpaw import GPAW, FD, restart, setup_paths
from gpaw.directmin.etdm_fdpw import FDPWETDM
from gpaw.mom import prepare_mom_calculation
import numpy as np

setup_paths.insert(0, '/users/home/aes38/basissets/')

atoms, calc = restart('../ground.gpw', txt='mixed.txt')
calc.wfs.initialize_wave_functions_from_restart_file()

nbands = calc.get_number_of_bands()

ratoms, rcalc = restart('/users/home/aes38/Rydberg/new/ammonia/complex/lcao/firstext/mixed.gpw')
rcalc.set_positions()
rcalc.wfs.initialize_wave_functions_from_lcao()

f_sn = [rcalc.wfs.kpt_u[x].f_n.copy() for x in range(len(rcalc.wfs.kpt_u))]
psit_nG = [rcalc.wfs.kpt_u[x].psit_nG.copy() for x in range(len(rcalc.wfs.kpt_u))]

calc.set(eigensolver=FDPWETDM(excited_state=True, printinnerloop=True, 
                              linesearch_algo={'name': 'max-step', 'max_step': 0.0}),
         convergence={'eigenstates': np.inf})

#calc.wfs.eigensolver.lsa = {'name': 'max-step', 'max_step': 0.0}
#calc.scf.criteria['eigenstates'].tol = np.inf

for k, kpt in enumerate(calc.wfs.kpt_u):
    for p, psit in enumerate(kpt.psit_nG):
        psit = psit_nG[k][p]

f_n = [f_sn[x][:nbands] for x in range(len(f_sn))]

prepare_mom_calculation(calc, atoms, f_n)

calc.calculate(properties=['energy'], system_changes=None)
calc.write('mixed.gpw', mode = 'all')


