from gpaw import GPAW, FD, restart, setup_paths
from ase.io import read
from gpaw.directmin.etdm_fdpw import FDPWETDM
from gpaw.directmin.tools import excite
from gpaw.directmin.derivatives import Davidson
from gpaw.mixer import DummyMixer
from gpaw.xc import XC

# mode = LCAO(force_complex_dtype=True) 
setup_paths.insert(0, '/users/home/aes38/basissets/')

atoms, calc = restart('/users/home/aes38/Rydberg/new/ammonia/complex/fd/ground.gpw', txt='ground.txt')

calc.set(eigensolver=FDPWETDM(functional='PZ-SIC', localizationtype='PM'))

atoms.get_potential_energy()

calc.write('ground.gpw', mode='all')

