from gpaw import GPAW, FD, setup_paths
from ase.io import read
from gpaw.directmin.etdm_fdpw import FDPWETDM
from gpaw.directmin.tools import excite
from gpaw.directmin.derivatives import Davidson
from gpaw.mixer import DummyMixer
from gpaw.xc import XC

atoms = read('../nh3.xyz')
atoms.center(vacuum=10.0)

# mode = LCAO() 
setup_paths.insert(0, '/users/home/aes38/basissets/')

calc = GPAW(mode=FD(),
        basis='aug-cc-pVDZ_PBE.sz',
        h=0.15,
        xc='PBE',
        maxiter=1000,
        mixer={'backend': 'no-mixing'},
        spinpol=True,
        eigensolver=FDPWETDM(),
        occupations={'name': 'fixed-uniform'},
        nbands=-10,
        symmetry='off',
        txt='ground.txt')

atoms.calc = calc
atoms.get_potential_energy()

calc.write('ground.gpw', mode='all')

