# EMBSeCBIO_Holocene_climate

Code related to the paper titled: 

## **Pollen-based reconstructions of Holocene climate trends in the eastern Mediterranean region.**

**Authors:** Esmeralda Cruz-Silva, Sandy P. Harrison, I. Colin Prentice, Elena Marinova, Patrick J. Bartlein, Hans Renssen, and Yurui Zhang

The paper can be accessed at the following link: https://egusphere.copernicus.org/preprints/2023/egusphere-2023-864/


**Abstract** 

There has been considerable debate about the degree to which climate has driven societal changes in the eastern Mediterranean region, partly through reliance on a limited number of qualitative records of climate changes and partly reflecting the need to disentangle the joint impact of changes in different aspects of climate. Here, we use tolerance-weighted Averaging Partial Least Squares to derive reconstructions of mean temperature of the coldest month (MTCO), mean temperature of the warmest month (MTWA), growing degree days above a threshold of 0°C (GDD0) and plant-available moisture, represented by the ratio of modelled actual to equilibrium evapotranspiration (α) and corrected for past CO2 changes for 71 individual pollen records from the Eastern Mediterranean region covering part or all of the interval from 12.3 ka to the present. We use these reconstructions to create regional composites that illustrate the long-term trends in each variable. We compare these composites with transient climate model simulations to explore potential causes of the observed trends. We show that the glacial-Holocene transition and the early part of the Holocene was characterised by conditions colder  than present. Rapid increases in temperature occurred between ca 10.3 and 9.3 ka, considerably after the end of the Younger Dryas.  Although the time series are characterised by centennial-to-millennial oscillations, MTCO showed a gradual increase from 9 ka to the present, consistent with the expectation that winter temperatures were forced by orbitally-induced increases in insolation during the Holocene. MTWA also showed an increasing trend from 9 ka and reached a maximum of ca 1.5°C greater than present at ca 4.5 and 5 ka, followed by a gradual decline towards present-day conditions. A delayed response to summer insolation changes is likely a reflection of the persistence of the Laurentide and Fennoscandian ice sheets; subsequent summer cooling is consistent with the expected response to insolation changes.  Plant-available moisture increased rapidly after 11 ka and conditions were wetter than today between 10-6 ka, but thereafter α declined gradually. These trends likely reflect changes in atmospheric circulation and moisture advection into the region, and were probably too small to influence summer temperature through land-surface feedbacks. Differences in the simulated trajectory of α in different models highlight the difficulties in reproducing circulation-driven moisture advection into the eastern Mediterranean.

**Description of the files**

`Climate_reconstructions.Rmd` Contains code to apply tolerance-wighted Averaging Partial Least Squeres to derive reconstructions of of the coldest month (MTCO), mean temperature of the warmest month (MTWA), growing degree days above a threshold of 0°C (GDD0) and plant-available moisture, represented by the ratio of modelled actual to equilibrium evapotranspiration (α)

`Timseries_individual.Rmd` Contains
