library(ggplot2)
library(ggthemes)
library(gridExtra)
library(ggpubr)

dt <- read.csv("fig_ei_ms_v2_2BRin1plot.csv")
dt$size_group <- factor(dt$Size,  levels = c('3.5-7.5t', '7.5-16t', '16-32t', '>32t') )



ggplot(dt, aes(x = factor(Activity), y = Ave_load, fill = Geography)) +
  geom_bar(stat = "identity", position = "dodge") +
  scale_fill_manual(values=c("#A67ee6",
                             "#411a77",
                             "#5DBE8A",
                             "#125a40",
                             "#e6a67e")) + #e6a67e   e67e8a
   
  xlab("activity type") +
  ylab("average load [metric ton]") +
  facet_grid(Emission~size_group,  scales="free", space="free_x", labeller = label_both) +
  
  geom_text(aes(label = Ave_load), position = position_dodge(width = 0.9), color="white", 
            fontface = "bold",size=3.3, vjust=1) + 

  theme_few() + 
  theme(text=element_text(size=12) , 
     strip.background = element_rect(
       color="black", fill="#67636b", linetype="solid"  #C6c3cb  
     ), 
     strip.text = element_text(colour = 'white', size=10, face = "bold")
  )  


ggsave("figS2.pdf",   width = 18.5, height = 9, dpi = 700, units = "in", device='pdf' )
dev.off()
#to change color_hue:  https://imagecolorpicker.com/color-code/a67ee6 





