library(ggplot2)
library(ggthemes)

dt <- read.csv("fig_ei_ms.csv")
dt <- subset(dt, Activity == "transforming activity")

dt$size_group <- factor(dt$Size,  levels = c('3.5-7.5t', '7.5-16t', '16-32t', '>32t') )

ggplot(dt, aes(x = factor(Activity), y = Ave_load, fill = Geography)) +
  geom_bar(stat = "identity", position = "dodge") +
  scale_fill_manual(values=c("#A67ee6",
                             "#5DBE8A",
                             "#125a40",
                             "#411a77")) + 
  
  xlab("activity type") +
  ylab("average load [metric ton]") +
  facet_grid(Emission~size_group,  scales="free", space="free_x", 
             switch="y",
             labeller = label_both) +
  
  geom_text(aes(label = Ave_load), position = position_dodge(width = 0.9), color="white", 
            fontface = "bold",size=4, vjust=1) + 

  theme_few() + 
  theme(axis.title.x=element_blank(),
        text=element_text(size=12) , 
        strip.background = element_rect(
          color="black", fill="#FCCB16", linetype="solid"  #C6c3cb  
        ), 
        strip.text = element_text(colour = 'black', size=10, face = "bold")
  )  


ggsave("fig4.pdf",   width = 326, height = 236, dpi = 700, units = "mm", device='pdf' )
ggsave("fig4.tiff",   width = 326, height = 236, dpi = 700, units = "mm", device='tiff' )


dev.off()