library(ggplot2)
library(ggthemes)
library(gridExtra)
library(ggpubr)


#################################  Fig 1 ##################################################
dt1 <- read.csv("resp_n.csv")
#dt1  
dt1_p <- ggplot(dt1, aes(x = factor(Q), y = Total_response_N, fill = Q_type)) +
  geom_bar(stat = "identity", position = "dodge") +
  scale_fill_manual(values=c("#bee67e",
                             "#a67ee6" )) + 
  xlab("Question") + ylab("N_response") +
  geom_text(aes(label = Total_response_N), position = position_dodge(width = 0.9), color="black", 
            fontface = "bold",size=5, vjust=1) + 
  theme_few()



dt2 <- read.csv("main_role.csv")
#dt2

dt2_p <- ggplot(dt2, aes(x = factor(Main.role), y = perct_num_totalN46)) + 
  ylim(0,1) + 
  geom_bar(stat = "identity", position = "dodge", fill="#bee67e") +
  scale_fill_manual(values=c("#bee67e")) + 
  xlab("Main Role as LCA practitioner") + ylab("% [total N = 46]") +
  geom_text(aes(label = perct), position = position_dodge(width = 0.9), color="black", 
            fontface = "bold",size=5, vjust=1) + 
  theme_few() + 
  theme(axis.text.x = element_text(angle = 45, vjust = 0.5, size = 10, hjust=0.4))




dt3 <- read.csv("year_exp.csv")
dt3

dt3_p <- ggplot(dt3, aes(x = factor(Years.of.experience), y = perct_num)) + 
  ylim(0,1) + 
  geom_bar(stat = "identity", position = "dodge", fill="#bee67e") +
  #scale_fill_manual(values=c("#bee67e")) + 
  xlab("Years of experience") + ylab("% [total N = 48]") +
  geom_text(aes(label = perct), position = position_dodge(width = 0.9), color="black", 
            fontface = "bold",size=5, vjust=1) + 
  theme_few() + 
  theme(axis.text.x = element_text(angle = 45, vjust = 0.5, size = 10, hjust=0.4))



fig1 <- ggarrange(dt1_p,                                              # First row
                  ggarrange(dt2_p,  dt3_p ,  ncol = 2 ),              # labels = c("B", "C") 
                  nrow = 2 
                  #labels = "A"                                         
) 

fig1 
ggsave("fig1.pdf", width = 326, height = 216, dpi = 700, units = "mm", device='pdf' )
ggsave("fig1.tiff",   width = 326, height = 216, dpi = 700, units = "mm", device='tiff' )
dev.off()




#################################  Fig 2 ##################################################
dt4 <- read.csv("D1.csv")
dt4
f_q <- dt4$full_question 

dt4_p <- ggplot(dt4, aes(x = factor(Q_short), y = perct_num)) + 
  ylim(0,1) + 
  geom_bar(stat = "identity", position = "dodge", fill="#bee67e") +
  xlab("Primary data being collected") + ylab("% [total N = 48]") +
  geom_text(aes(label = perct), position = position_dodge(width = 0.9), color="black", 
            fontface = "bold",size=5, vjust=1) + 
  theme_few() +  
  theme(axis.text.x = element_text(angle = 0, vjust = 0.5, size = 11, hjust=0.4)) + 
  geom_text(aes(label = f_q), vjust = c(1.3,2.3,3,3.6,2.2), hjust=0.5, size = 4)




dt5 <- read.csv("D2.csv")
dt5
dt5_p <- ggplot(dt5, aes(x = factor(Q_short), y = perct_num)) + 
  ylim(0,1) +
  geom_bar(stat = "identity", position = "dodge", fill="#e6a67e") +
  xlab("Background database used") + ylab("% [total N = 48]") +
  geom_text(aes(label = perct), position = position_dodge(width = 0.9), color="black", 
            fontface = "bold",size=5, vjust=1) + 
  theme_few()  +  
  theme(axis.text.x = element_text(angle = 0, vjust = 0.5, size = 11, hjust=0.4)) 




dt6 <- read.csv("D3.csv")
dt6

dt6_p <- ggplot(dt6, aes(x = factor(Q_short), y = perct_num)) + 
  geom_bar(stat = "identity", position = "dodge", fill="#a67ee6") +
  ylim(0,1) +
  xlab("Questions asked for road freight") + ylab("% [total N = 48]") +
  geom_text(aes(label = perct), position = position_dodge(width = 0.9), color="black", 
            fontface = "bold",size=5, vjust=1) + 
  theme_few() +  
  theme(axis.text.x = element_text(angle = 0, vjust = 0.5, size = 11, hjust=0.4)) 




fig2 <- ggarrange(dt4_p, dt5_p, dt6_p,  ncol = 3, nrow = 1)
fig2

ggsave("fig2.pdf", width = 326, height = 216, dpi = 700, units = "mm", device='pdf' )
ggsave("fig2.tiff",   width = 326, height = 216, dpi = 700, units = "mm", device='tiff' )

dev.off()

