% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esd_table_pba.R
\name{esd_table_pba}
\alias{esd_table_pba}
\title{Creating a table for field-specific effect size benchmarks, adjusted for
publication bias}
\usage{
esd_table_pba(
  lim_obj,
  grouping = FALSE,
  method = "quads",
  min_group_size = 3,
  csv_write = FALSE,
  path_file_name = "esd_table.csv",
  ndec = 2
)
}
\arguments{
\item{lim_obj}{An object of class "limitmeta".}

\item{grouping}{Defaults to FALSE. When set to TRUE, will detect subgrouping
of the lim_obj and calculate benchmarks for each group.}

\item{method}{Defaults to 'quads', can also be 'thirds'.}

\item{min_group_size}{Sets the minimum amount of effect sizes needed to
include a group in the table. Defaults to 3.}

\item{csv_write}{Defaults to FALSE. Will write the outputted table as a csv.}

\item{path_file_name}{A string containing the directory to which the .csv
file will be saved, including the title of the .csv file (has to end in
'.csv').}

\item{ndec}{The number of decimal places in which all values should be
reported. Defaults to 2.}
}
\value{
A table.
}
\description{
Creating a table for field-specific effect size benchmarks, adjusted for
publication bias
}
\examples{
m2 <- meta::metagen(TE = ot_dat$yi,
                    seTE = ot_dat$sei,
                    subgroup = ot_dat$group)
l2 <- metasens::limitmeta(m2)
esd_table_pba(lim_obj = l2, grouping = TRUE)


}
