% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esd_table.R
\name{esd_table}
\alias{esd_table}
\title{Creating a table for field-specific effect size benchmarks}
\usage{
esd_table(
  df,
  es,
  grouping_var = NULL,
  method = "quads",
  min_group_size = 3,
  csv_write = FALSE,
  path_file_name = "esd_table.csv",
  ndec = 2
)
}
\arguments{
\item{df}{Dataset.}

\item{es}{Column name of effect sizes.}

\item{grouping_var}{Column name of grouping variable/}

\item{method}{Defaults to 'quads', can also be 'thirds'.}

\item{min_group_size}{Sets the minimum amount of effect sizes needed to
include a group in the table. Defaults to 3.}

\item{csv_write}{Defaults to FALSE. Will write the outputted table as a csv.}

\item{path_file_name}{A string containing the directory to which the .csv
file will be saved, including the title of the .csv file (has to end in
'.csv').}

\item{ndec}{The number of decimal places in which all values should be
reported. Defaults to 2.}
}
\value{
A table.
}
\description{
Creating a table for field-specific effect size benchmarks
}
\examples{
esd_table(ot_dat, yi, grouping_var = group, method = "thirds")


}
