% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esd_plot_pba.R
\name{esd_plot_pba}
\alias{esd_plot_pba}
\title{Creating an iceberg plot to visualise publication bias adjustment.}
\usage{
esd_plot_pba(
  lim_obj,
  es_type,
  sesoi = NULL,
  sum_es = TRUE,
  method = FALSE,
  abs = FALSE,
  sum_es_type = "diamond",
  bin_width = 0.1
)
}
\arguments{
\item{lim_obj}{An object of class "limitmeta".}

\item{es_type}{A string describing the type of effect size used (e.g.,
"Cohen's d").}

\item{sesoi}{A numeric argument that corresponds to the population ES of
interest. This will split the histogram into two parts around the inputted
value.}

\item{sum_es}{Defaults to TRUE. Plots the summary effect
size and 95\% CI for both the distribution of raw effect sizes as well as
the distribution of adjusted effect sizes.}

\item{method}{Defaults to FALSE, can also be 'thirds' for 16.65th, 50th, and
83.35th percentiles, or 'quads' for 25th, 50th, and 75th percentiles.}

\item{abs}{Defaults to FALSE. If set to TRUE, plots all effect sizes as
absolute values.}

\item{sum_es_type}{Defaults to "diamond". Sets the type of summary effect
size visualisation. "diamond" will create a diamond shape centred around
the summary effect size, with the width of the diamond showing the 95\% CI.
Can also be set to "dot", which shows a dot centred on the summary effect
size, with lines and brackets showing the width of the 95\% CI.}

\item{bin_width}{Numeric argument that corresponds to the bin width for the
histogram. Defaults to 0.1}
}
\value{
A ggplot object.
}
\description{
Creating an iceberg plot to visualise publication bias adjustment.
}
\examples{
m1 <- meta::metagen(TE = ot_dat$yi, seTE = ot_dat$sei)
l1 <- metasens::limitmeta(m1)
esd_plot_pba(lim_obj = l1, es_type = "Cohen's d", sum_es = TRUE)

}
