% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esd_plot_group.R
\name{esd_plot_group}
\alias{esd_plot_group}
\title{Creating an ESD plot per group}
\usage{
esd_plot_group(
  df,
  es,
  es_type,
  grouping_var,
  method = FALSE,
  mean = FALSE,
  abs = FALSE,
  min_group_size = 20,
  bin_width = 0.1
)
}
\arguments{
\item{df}{Dataset}

\item{es}{Column name of effect sizes}

\item{es_type}{A string describing the type of effect size used (e.g.,
"Cohen's d")}

\item{grouping_var}{Column name of grouping variable}

\item{method}{Defaults to FALSE, but can be 'quads' or 'thirds'}

\item{mean}{Defaults to FALSE, but will insert a ggplot geom_vline element
that corresponds to the mean effect size}

\item{abs}{Defaults to FALSE. If set to TRUE, plots all effect sizes as
absolute values}

\item{min_group_size}{Numeric value corresponding to the minimum amount of
effect sizes for a group to be included in the plot. Defaults to 20.}

\item{bin_width}{Numeric argument that corresponds to the bin width for the
histogram. Defaults to 0.1}
}
\value{
A ggplot element
}
\description{
Creating an ESD plot per group
}
\examples{
esd_plot_group(df = ot_dat,
                         es = yi,
                         grouping_var = group,
                         es_type = "Hedges' g")
}
