% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esd_plot.R
\name{esd_plot}
\alias{esd_plot}
\title{Creating a plot for an effect size distribution}
\usage{
esd_plot(
  df,
  es,
  es_type,
  method = FALSE,
  mean = NULL,
  sesoi = NULL,
  abs = FALSE,
  bin_width = 0.1
)
}
\arguments{
\item{df}{Dataset.}

\item{es}{Column name of effect sizes.}

\item{es_type}{A string describing the type of effect size used (e.g.,
"Cohen's d").}

\item{method}{Defaults to FALSE, can also be 'thirds' for 16.65th, 50th, and
83.35th percentiles, or 'quads' for 25th, 50th, and 75th percentiles.}

\item{mean}{Defaults to NULL, but will insert a ggplot geom_vline element
that corresponds to the mean effect size if set to 'mean' or takes on
a numeric argument to generate a geom_vline element that corresponds to
the inputted value.}

\item{sesoi}{A numeric argument that corresponds to the population ES of
interest. This will split the histogram into two parts around the inputted
value.}

\item{abs}{Defaults to FALSE. If set to TRUE, plots all effect sizes as
absolute values.}

\item{bin_width}{Numeric argument that corresponds to the bin width for the
histogram. Defaults to 0.1.}
}
\value{
A ggplot object.
}
\description{
Creating a plot for an effect size distribution
}
\examples{
esd_plot(df = ot_dat,
                   es = yi,
                   es_type = "Cohen's d")
}
