# Generated by Django 3.2.18 on 2023-02-14 14:53

from django.db import migrations, models

import grandchallenge.core.validators


class Migration(migrations.Migration):

    dependencies = [
        (
            "workstations",
            "0015_feedbackgroupobjectpermission_feedbackuserobjectpermission_sessiongroupobjectpermission_sessionusero",
        ),
    ]

    operations = [
        migrations.AddField(
            model_name="historicalsession",
            name="extra_env_vars",
            field=models.JSONField(
                blank=True,
                default=list,
                help_text="Extra environment variables to include in this session",
                validators=[
                    grandchallenge.core.validators.JSONValidator(
                        schema={
                            "$schema": "http://json-schema.org/draft-06/schema",
                            "description": "Defines environment variable names and values",
                            "items": {
                                "$id": "#/items",
                                "additionalProperties": False,
                                "description": "Defines an environment variable",
                                "properties": {
                                    "name": {
                                        "$id": "#/items/properties/name",
                                        "default": "ENV_VAR",
                                        "description": "The name of this environment variable",
                                        "examples": ["ENV_VAR"],
                                        "pattern": "^[A-Z0-9\\_]+$",
                                        "title": "The Name Schema",
                                        "type": "string",
                                    },
                                    "value": {
                                        "$id": "#/items/properties/value",
                                        "default": "env_var_value",
                                        "description": "The value of this environment variable",
                                        "examples": ["env_var_value"],
                                        "title": "The Value Schema",
                                        "type": "string",
                                    },
                                },
                                "required": ["name", "value"],
                                "title": "The Environment Variable Schema",
                                "type": "object",
                            },
                            "title": "The Environment Variables Schema",
                            "type": "array",
                        }
                    )
                ],
            ),
        ),
        migrations.AddField(
            model_name="session",
            name="extra_env_vars",
            field=models.JSONField(
                blank=True,
                default=list,
                help_text="Extra environment variables to include in this session",
                validators=[
                    grandchallenge.core.validators.JSONValidator(
                        schema={
                            "$schema": "http://json-schema.org/draft-06/schema",
                            "description": "Defines environment variable names and values",
                            "items": {
                                "$id": "#/items",
                                "additionalProperties": False,
                                "description": "Defines an environment variable",
                                "properties": {
                                    "name": {
                                        "$id": "#/items/properties/name",
                                        "default": "ENV_VAR",
                                        "description": "The name of this environment variable",
                                        "examples": ["ENV_VAR"],
                                        "pattern": "^[A-Z0-9\\_]+$",
                                        "title": "The Name Schema",
                                        "type": "string",
                                    },
                                    "value": {
                                        "$id": "#/items/properties/value",
                                        "default": "env_var_value",
                                        "description": "The value of this environment variable",
                                        "examples": ["env_var_value"],
                                        "title": "The Value Schema",
                                        "type": "string",
                                    },
                                },
                                "required": ["name", "value"],
                                "title": "The Environment Variable Schema",
                                "type": "object",
                            },
                            "title": "The Environment Variables Schema",
                            "type": "array",
                        }
                    )
                ],
            ),
        ),
    ]
