# Generated by Django 3.1.1 on 2020-11-26 11:26

import datetime
import uuid
from decimal import Decimal

import django.core.validators
import django.db.models.deletion
import django_extensions.db.fields
import simple_history.models
from django.conf import settings
from django.db import migrations, models

import grandchallenge.components.models
import grandchallenge.core.storage
import grandchallenge.core.validators


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("auth", "0011_update_proxy_permissions"),
        ("workstation_configs", "0001_squashed_0008_auto_20201001_0758"),
    ]

    operations = [
        migrations.CreateModel(
            name="Workstation",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True)),
                ("modified", models.DateTimeField(auto_now=True)),
                (
                    "title",
                    models.CharField(max_length=255, verbose_name="title"),
                ),
                (
                    "description",
                    models.TextField(
                        blank=True, null=True, verbose_name="description"
                    ),
                ),
                (
                    "slug",
                    django_extensions.db.fields.AutoSlugField(
                        blank=True,
                        editable=False,
                        populate_from="title",
                        verbose_name="slug",
                    ),
                ),
                (
                    "logo",
                    models.ImageField(
                        storage=grandchallenge.core.storage.PublicS3Storage(),
                        upload_to=grandchallenge.core.storage.get_logo_path,
                    ),
                ),
                (
                    "editors_group",
                    models.OneToOneField(
                        editable=False,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="editors_of_workstation",
                        to="auth.group",
                    ),
                ),
                (
                    "users_group",
                    models.OneToOneField(
                        editable=False,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="users_of_workstation",
                        to="auth.group",
                    ),
                ),
                (
                    "config",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="workstation_configs.workstationconfig",
                    ),
                ),
                (
                    "public",
                    models.BooleanField(
                        default=False,
                        help_text="If True, all logged in users can use this viewer, otherwise, only the users group can use this viewer.",
                    ),
                ),
            ],
            options={"abstract": False, "ordering": ("created", "title")},
        ),
        migrations.CreateModel(
            name="WorkstationImage",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True)),
                ("modified", models.DateTimeField(auto_now=True)),
                (
                    "staged_image_uuid",
                    models.UUIDField(blank=True, editable=False, null=True),
                ),
                (
                    "image",
                    models.FileField(
                        blank=True,
                        help_text=".tar.xz archive of the container image produced from the command 'docker save IMAGE | xz -T0 -c > IMAGE.tar.xz'. See https://docs.docker.com/engine/reference/commandline/save/",
                        storage=grandchallenge.core.storage.PrivateS3Storage(),
                        upload_to=grandchallenge.components.models.docker_image_path,
                        validators=[
                            grandchallenge.core.validators.ExtensionValidator(
                                allowed_extensions=(
                                    ".tar",
                                    ".tar.gz",
                                    ".tar.xz",
                                )
                            )
                        ],
                    ),
                ),
                (
                    "image_sha256",
                    models.CharField(editable=False, max_length=71),
                ),
                (
                    "ready",
                    models.BooleanField(
                        default=False,
                        editable=False,
                        help_text="Is this image ready to be used?",
                    ),
                ),
                ("status", models.TextField(editable=False)),
                ("requires_gpu", models.BooleanField(default=False)),
                (
                    "requires_gpu_memory_gb",
                    models.PositiveIntegerField(default=4),
                ),
                ("requires_memory_gb", models.PositiveIntegerField(default=4)),
                (
                    "requires_cpu_cores",
                    models.DecimalField(
                        decimal_places=2, default=Decimal("1.0"), max_digits=4
                    ),
                ),
                (
                    "http_port",
                    models.PositiveIntegerField(
                        default=8080,
                        validators=[
                            django.core.validators.MaxValueValidator(65535)
                        ],
                    ),
                ),
                (
                    "websocket_port",
                    models.PositiveIntegerField(
                        default=4114,
                        validators=[
                            django.core.validators.MaxValueValidator(65535)
                        ],
                    ),
                ),
                (
                    "initial_path",
                    models.CharField(
                        default="cirrus",
                        max_length=256,
                        validators=[
                            django.core.validators.RegexValidator(
                                message="This path is invalid, it must not start with a /",
                                regex="^(?:[^/][^\\s]*)\\Z",
                            )
                        ],
                    ),
                ),
                (
                    "creator",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "workstation",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="workstations.workstation",
                    ),
                ),
            ],
            options={"abstract": False, "ordering": ("created", "creator")},
        ),
        migrations.CreateModel(
            name="HistoricalSession",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        db_index=True, default=uuid.uuid4, editable=False
                    ),
                ),
                ("created", models.DateTimeField(blank=True, editable=False)),
                ("modified", models.DateTimeField(blank=True, editable=False)),
                (
                    "status",
                    models.PositiveSmallIntegerField(
                        choices=[
                            (0, "Queued"),
                            (1, "Started"),
                            (2, "Running"),
                            (3, "Failed"),
                            (4, "Stopped"),
                        ],
                        default=0,
                    ),
                ),
                (
                    "maximum_duration",
                    models.DurationField(
                        default=datetime.timedelta(seconds=600)
                    ),
                ),
                ("user_finished", models.BooleanField(default=False)),
                (
                    "history_id",
                    models.AutoField(primary_key=True, serialize=False),
                ),
                ("history_date", models.DateTimeField()),
                (
                    "history_change_reason",
                    models.CharField(max_length=100, null=True),
                ),
                (
                    "history_type",
                    models.CharField(
                        choices=[
                            ("+", "Created"),
                            ("~", "Changed"),
                            ("-", "Deleted"),
                        ],
                        max_length=1,
                    ),
                ),
                (
                    "creator",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "workstation_image",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="workstations.workstationimage",
                    ),
                ),
                (
                    "region",
                    models.CharField(
                        choices=[
                            ("af-south-1", "Africa (Cape Town)"),
                            ("ap-east-1", "Asia Pacific (Hong Kong)"),
                            ("ap-northeast-1", "Asia Pacific (Tokyo)"),
                            ("ap-northeast-2", "Asia Pacific (Seoul)"),
                            ("ap-northeast-3", "Asia Pacific (Osaka-Local)"),
                            ("ap-south-1", "Asia Pacific (Mumbai)"),
                            ("ap-southeast-1", "Asia Pacific (Singapore)"),
                            ("ap-southeast-2", "Asia Pacific (Sydney)"),
                            ("ca-central-1", "Canada (Central)"),
                            ("eu-central-1", "Europe (Frankfurt)"),
                            ("eu-north-1", "Europe (Stockholm)"),
                            ("eu-south-1", "Europe (Milan)"),
                            ("eu-west-1", "Europe (Ireland)"),
                            ("eu-west-2", "Europe (London)"),
                            ("eu-west-3", "Europe (Paris)"),
                            ("me-south-1", "Middle East (Bahrain)"),
                            ("sa-east-1", "South America (São Paulo)"),
                            ("us-east-1", "US East (N. Virginia)"),
                            ("us-east-2", "US East (Ohio)"),
                            ("us-west-1", "US West (N. California)"),
                            ("us-west-2", "US West (Oregon)"),
                            ("eu-nl-1", "Netherlands (Nijmegen)"),
                            ("eu-nl-2", "Netherlands (Amsterdam)"),
                        ],
                        default="eu-nl-1",
                        help_text="Which region is this session available in?",
                        max_length=14,
                    ),
                ),
            ],
            options={
                "verbose_name": "historical session",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="Session",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True)),
                ("modified", models.DateTimeField(auto_now=True)),
                (
                    "status",
                    models.PositiveSmallIntegerField(
                        choices=[
                            (0, "Queued"),
                            (1, "Started"),
                            (2, "Running"),
                            (3, "Failed"),
                            (4, "Stopped"),
                        ],
                        default=0,
                    ),
                ),
                (
                    "maximum_duration",
                    models.DurationField(
                        default=datetime.timedelta(seconds=600)
                    ),
                ),
                ("user_finished", models.BooleanField(default=False)),
                (
                    "creator",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "workstation_image",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="workstations.workstationimage",
                    ),
                ),
                ("logs", models.TextField(blank=True, editable=False)),
                (
                    "region",
                    models.CharField(
                        choices=[
                            ("af-south-1", "Africa (Cape Town)"),
                            ("ap-east-1", "Asia Pacific (Hong Kong)"),
                            ("ap-northeast-1", "Asia Pacific (Tokyo)"),
                            ("ap-northeast-2", "Asia Pacific (Seoul)"),
                            ("ap-northeast-3", "Asia Pacific (Osaka-Local)"),
                            ("ap-south-1", "Asia Pacific (Mumbai)"),
                            ("ap-southeast-1", "Asia Pacific (Singapore)"),
                            ("ap-southeast-2", "Asia Pacific (Sydney)"),
                            ("ca-central-1", "Canada (Central)"),
                            ("eu-central-1", "Europe (Frankfurt)"),
                            ("eu-north-1", "Europe (Stockholm)"),
                            ("eu-south-1", "Europe (Milan)"),
                            ("eu-west-1", "Europe (Ireland)"),
                            ("eu-west-2", "Europe (London)"),
                            ("eu-west-3", "Europe (Paris)"),
                            ("me-south-1", "Middle East (Bahrain)"),
                            ("sa-east-1", "South America (São Paulo)"),
                            ("us-east-1", "US East (N. Virginia)"),
                            ("us-east-2", "US East (Ohio)"),
                            ("us-west-1", "US West (N. California)"),
                            ("us-west-2", "US West (Oregon)"),
                            ("eu-nl-1", "Netherlands (Nijmegen)"),
                            ("eu-nl-2", "Netherlands (Amsterdam)"),
                        ],
                        default="eu-nl-1",
                        help_text="Which region is this session available in?",
                        max_length=14,
                    ),
                ),
                ("ping_times", models.JSONField(default=None, null=True)),
            ],
            options={"abstract": False, "ordering": ("created", "creator")},
        ),
    ]
