# Generated by Django 3.2.16 on 2023-01-16 15:00

import django.core.validators
from django.db import migrations, models

import grandchallenge.core.fields


class Migration(migrations.Migration):

    dependencies = [
        ("workstation_configs", "0019_workstationconfig_show_swivel_tool"),
    ]

    operations = [
        migrations.AddField(
            model_name="workstationconfig",
            name="default_annotation_color",
            field=grandchallenge.core.fields.HexColorField(
                blank=True,
                help_text="Default color for displaying and creating annotations",
                max_length=7,
                null=True,
                validators=[
                    django.core.validators.RegexValidator(
                        message="This is an invalid color code. It must be an HTML hexadecimal color code e.g. #000000",
                        regex="^#[a-fA-F0-9]{6}$",
                    ),
                ],
            ),
        ),
        migrations.AddField(
            model_name="workstationconfig",
            name="default_brush_size",
            field=models.DecimalField(
                blank=True,
                decimal_places=7,
                help_text="Default brush size in millimeter for creating annotations",
                max_digits=8,
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(limit_value=1e-6)
                ],
            ),
        ),
    ]
