# Generated by Django 3.2.10 on 2022-02-11 13:01

import django.core.validators
import django.db.models.deletion
from django.db import migrations, models

import grandchallenge.core.validators


class Migration(migrations.Migration):

    dependencies = [
        ("workstation_configs", "0011_workstationconfig_link_images")
    ]

    operations = [
        migrations.AlterField(
            model_name="workstationconfig",
            name="auto_jump_center_of_gravity",
            field=models.BooleanField(
                default=True,
                help_text="Enables a jump to center of gravity of the first output when viewing algorithm outputs or the first overlay segment when viewing a reader study",
            ),
        ),
        migrations.AlterField(
            model_name="workstationconfig",
            name="default_orientation",
            field=models.CharField(
                blank=True,
                choices=[("A", "Axial"), ("C", "Coronal"), ("S", "Sagittal")],
                help_text="The orientation that defines the 3D-intersection plane used to render slabs of 3D images",
                max_length=1,
            ),
        ),
        migrations.AlterField(
            model_name="workstationconfig",
            name="default_overlay_alpha",
            field=models.DecimalField(
                blank=True,
                decimal_places=2,
                help_text="The alpha value used for setting the degree of opacity for displayed pixels of overlay images",
                max_digits=3,
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(limit_value=0.0),
                    django.core.validators.MaxValueValidator(limit_value=1.0),
                ],
            ),
        ),
        migrations.AlterField(
            model_name="workstationconfig",
            name="default_overlay_interpolation",
            field=models.CharField(
                blank=True,
                choices=[("NN", "NearestNeighbor"), ("TL", "Trilinear")],
                default="NN",
                help_text="The method used to interpolate multiple voxels of overlay images and project them to screen pixels",
                max_length=2,
            ),
        ),
        migrations.AlterField(
            model_name="workstationconfig",
            name="default_overlay_lut",
            field=models.ForeignKey(
                blank=True,
                help_text="The look-up table that is applied when an overlay image is fist shown",
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                to="workstation_configs.lookuptable",
            ),
        ),
        migrations.AlterField(
            model_name="workstationconfig",
            name="default_slab_render_method",
            field=models.CharField(
                blank=True,
                choices=[
                    ("MAX", "Maximum"),
                    ("MIN", "Minimum"),
                    ("AVG", "Average"),
                ],
                help_text="The method used to project multiple voxels in the volume, found within the slab thickness column, to displayed pixels",
                max_length=3,
            ),
        ),
        migrations.AlterField(
            model_name="workstationconfig",
            name="default_slab_thickness_mm",
            field=models.DecimalField(
                blank=True,
                decimal_places=2,
                help_text="The size (depth/Z size) in millimeters used to project image values to displayed pixels",
                max_digits=4,
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(limit_value=0.01)
                ],
            ),
        ),
        migrations.AlterField(
            model_name="workstationconfig",
            name="default_window_preset",
            field=models.ForeignKey(
                blank=True,
                help_text="The preset that is applied when an image is fist shown",
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="workstation_default_window_presets",
                to="workstation_configs.windowpreset",
            ),
        ),
        migrations.AlterField(
            model_name="workstationconfig",
            name="enable_contrast_enhancement",
            field=models.BooleanField(
                default=False,
                help_text="A tool that uses image preprocessing to enhance contrast. It is mainly used for viewing eye-fundus images",
                verbose_name="Contrast-enhancement preprocessing tool",
            ),
        ),
        migrations.AlterField(
            model_name="workstationconfig",
            name="image_context",
            field=models.CharField(
                blank=True,
                choices=[
                    ("PATH", "Pathology"),
                    ("OPHTH", "Ophthalmology"),
                    ("MPMRI", "Multiparametric MRI"),
                ],
                help_text="Sets several heuristics used for automatically selecting tools, hanging protocols, et cetera",
                max_length=6,
            ),
        ),
        migrations.AlterField(
            model_name="workstationconfig",
            name="key_bindings",
            field=models.JSONField(
                blank=True,
                default=list,
                help_text="The schema that overwrites the mapping between keyboard shortcuts and viewer actions",
                validators=[
                    grandchallenge.core.validators.JSONValidator(
                        schema={
                            "$id": "http://example.com/example.json",
                            "$schema": "http://json-schema.org/draft-06/schema",
                            "description": "Define the key bindings for the workstation.",
                            "items": {
                                "$id": "#/items",
                                "additionalProperties": False,
                                "default": {},
                                "description": "Defines a key binding for a command.",
                                "examples": [
                                    {
                                        "command": "editor.action.deleteLines",
                                        "key": "ctrl+shift+k",
                                        "when": "editorTextFocus",
                                    }
                                ],
                                "properties": {
                                    "command": {
                                        "$id": "#/items/properties/command",
                                        "default": "",
                                        "description": "The command called by this binding.",
                                        "examples": [
                                            "editor.action.deleteLines"
                                        ],
                                        "title": "The Command Schema",
                                        "type": "string",
                                    },
                                    "key": {
                                        "$id": "#/items/properties/key",
                                        "default": "",
                                        "description": "The keys used for this binding.",
                                        "examples": ["ctrl+shift+k"],
                                        "title": "The Key Schema",
                                        "type": "string",
                                    },
                                    "when": {
                                        "$id": "#/items/properties/when",
                                        "default": "",
                                        "description": "The condition that must be met for this command to be called.",
                                        "examples": ["editorTextFocus"],
                                        "title": "The When Schema",
                                        "type": "string",
                                    },
                                },
                                "required": ["key", "command"],
                                "title": "The Key Binding Schema",
                                "type": "object",
                            },
                            "title": "The Key Bindings Schema",
                            "type": "array",
                        }
                    )
                ],
            ),
        ),
        migrations.AlterField(
            model_name="workstationconfig",
            name="overlay_luts",
            field=models.ManyToManyField(
                blank=True,
                help_text="The preset look-up tables options that are used to project overlay-image values to displayed pixel colors",
                related_name="workstation_overlay_luts",
                to="workstation_configs.LookUpTable",
            ),
        ),
        migrations.AlterField(
            model_name="workstationconfig",
            name="overlay_segments",
            field=models.JSONField(
                blank=True,
                default=list,
                help_text="The schema that defines how categories of values in the overlay images are differentiated",
                validators=[
                    grandchallenge.core.validators.JSONValidator(
                        schema={
                            "$id": "http://example.com/example.json",
                            "$schema": "http://json-schema.org/draft-06/schema",
                            "description": "Define the overlay segments for the LUT.",
                            "items": {
                                "$id": "#/items",
                                "additionalProperties": False,
                                "default": {},
                                "description": "Defines what each segment of the LUT represents.",
                                "examples": [
                                    {
                                        "metric_template": "{{metrics.volumes[0]}} mm³",
                                        "name": "Metastasis",
                                        "visible": True,
                                        "voxel_value": 1,
                                    }
                                ],
                                "properties": {
                                    "metric_template": {
                                        "$id": "#/items/properties/metric_template",
                                        "default": "",
                                        "description": "The jinja template to determine which property from the results.json should be used as the label text.",
                                        "examples": [
                                            "{{metrics.volumes[0]}} mm³"
                                        ],
                                        "title": "The Metric Template Schema",
                                        "type": "string",
                                    },
                                    "name": {
                                        "$id": "#/items/properties/name",
                                        "default": "",
                                        "description": "What this segment should be called.",
                                        "examples": ["Metastasis"],
                                        "title": "The Name Schema",
                                        "type": "string",
                                    },
                                    "visible": {
                                        "$id": "#/items/properties/visible",
                                        "default": True,
                                        "description": "Whether this segment is visible by default.",
                                        "examples": [True],
                                        "title": "The Visible Schema",
                                        "type": "boolean",
                                    },
                                    "voxel_value": {
                                        "$id": "#/items/properties/voxel_value",
                                        "default": 0,
                                        "description": "The value of the LUT for this segment.",
                                        "examples": [1],
                                        "title": "The Voxel Value Schema",
                                        "type": "integer",
                                    },
                                },
                                "required": ["voxel_value", "name", "visible"],
                                "title": "The Segment Schema",
                                "type": "object",
                            },
                            "title": "The Overlay Segments Schema",
                            "type": "array",
                        }
                    )
                ],
            ),
        ),
        migrations.AlterField(
            model_name="workstationconfig",
            name="show_algorithm_output_plugin",
            field=models.BooleanField(
                default=True,
                help_text="A plugin that shows algorithm outputs, including navigation controls",
            ),
        ),
        migrations.AlterField(
            model_name="workstationconfig",
            name="show_annotation_counter_tool",
            field=models.BooleanField(
                default=True,
                help_text="A tool that can be used to show summary statistics of annotations within an area",
            ),
        ),
        migrations.AlterField(
            model_name="workstationconfig",
            name="show_display_plugin",
            field=models.BooleanField(
                default=True,
                help_text="A plugin that allows control over display properties such as window preset, slab thickness, or orientation",
            ),
        ),
        migrations.AlterField(
            model_name="workstationconfig",
            name="show_flip_tool",
            field=models.BooleanField(
                default=True,
                help_text="A tool/button that allows vertical flipping/mirroring of an image",
            ),
        ),
        migrations.AlterField(
            model_name="workstationconfig",
            name="show_image_info_plugin",
            field=models.BooleanField(
                default=True,
                help_text="A plugin that shows meta-data information derived from image headers as well as any configured case text for reader studies",
            ),
        ),
        migrations.AlterField(
            model_name="workstationconfig",
            name="show_image_switcher_plugin",
            field=models.BooleanField(
                default=True,
                help_text="A plugin that allows switching images when viewing algorithm outputs",
            ),
        ),
        migrations.AlterField(
            model_name="workstationconfig",
            name="show_invert_tool",
            field=models.BooleanField(
                default=True,
                help_text="A tool/button that allows inverting the displayed pixel colors of an image",
            ),
        ),
        migrations.AlterField(
            model_name="workstationconfig",
            name="show_lut_selection_tool",
            field=models.BooleanField(
                default=True,
                help_text="A tool that allows switching between the overlay-lut presets",
                verbose_name="Show overlay-lut selection tool",
            ),
        ),
        migrations.AlterField(
            model_name="workstationconfig",
            name="show_overlay_plugin",
            field=models.BooleanField(
                default=True,
                help_text="A plugin that contains overlay-related controls, such as the overlay-selection tool and overlay-segmentation visibility",
            ),
        ),
        migrations.AlterField(
            model_name="workstationconfig",
            name="show_overlay_selection_tool",
            field=models.BooleanField(
                default=True,
                help_text="A tool that allows switching overlay images when viewing algorithm outputs",
            ),
        ),
        migrations.AlterField(
            model_name="workstationconfig",
            name="show_reset_tool",
            field=models.BooleanField(
                default=True,
                help_text="A tool/button that resets all display properties of the images to defaults",
            ),
        ),
        migrations.AlterField(
            model_name="workstationconfig",
            name="show_window_level_tool",
            field=models.BooleanField(
                default=True,
                help_text="A tool that allows selection of window presets and changing the window width/center",
            ),
        ),
        migrations.AlterField(
            model_name="workstationconfig",
            name="window_presets",
            field=models.ManyToManyField(
                blank=True,
                help_text="Window-preset options that change the projection of (computed) image values to displayed pixels",
                related_name="workstation_window_presets",
                to="workstation_configs.WindowPreset",
            ),
        ),
    ]
