# Generated by Django 3.1.1 on 2020-11-26 12:00

import uuid

import django.core.validators
import django.db.models.deletion
import django_extensions.db.fields
from django.conf import settings
from django.db import migrations, models

import grandchallenge.core.validators


class Migration(migrations.Migration):
    initial = True

    dependencies = [migrations.swappable_dependency(settings.AUTH_USER_MODEL)]

    operations = [
        migrations.CreateModel(
            name="LookUpTable",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "title",
                    models.CharField(max_length=255, verbose_name="title"),
                ),
                (
                    "description",
                    models.TextField(
                        blank=True, null=True, verbose_name="description"
                    ),
                ),
                (
                    "slug",
                    django_extensions.db.fields.AutoSlugField(
                        blank=True,
                        editable=False,
                        populate_from="title",
                        verbose_name="slug",
                    ),
                ),
                (
                    "color",
                    models.TextField(
                        validators=[
                            django.core.validators.RegexValidator(
                                regex="^\\[(?:((?: ?-?\\d*(?:\\.\\d+)? ){3}(?:-?\\d*(?:\\.\\d+)?)) ?, ?)+((?:-?\\d*(?:\\.\\d+)? ){3}(?:\\d*(:?\\.\\d+)? ?))\\]$"
                            )
                        ]
                    ),
                ),
                (
                    "alpha",
                    models.TextField(
                        validators=[
                            django.core.validators.RegexValidator(
                                regex="^\\[(?:((?: ?-?\\d*(?:\\.\\d+)? ){1}(?:-?\\d*(?:\\.\\d+)?)) ?, ?)+((?:-?\\d*(?:\\.\\d+)? ){1}(?:\\d*(:?\\.\\d+)? ?))\\]$"
                            )
                        ]
                    ),
                ),
                (
                    "color_invert",
                    models.TextField(
                        blank=True,
                        validators=[
                            django.core.validators.RegexValidator(
                                regex="^\\[(?:((?: ?-?\\d*(?:\\.\\d+)? ){3}(?:-?\\d*(?:\\.\\d+)?)) ?, ?)+((?:-?\\d*(?:\\.\\d+)? ){3}(?:\\d*(:?\\.\\d+)? ?))\\]$"
                            )
                        ],
                    ),
                ),
                (
                    "alpha_invert",
                    models.TextField(
                        blank=True,
                        validators=[
                            django.core.validators.RegexValidator(
                                regex="^\\[(?:((?: ?-?\\d*(?:\\.\\d+)? ){1}(?:-?\\d*(?:\\.\\d+)?)) ?, ?)+((?:-?\\d*(?:\\.\\d+)? ){1}(?:\\d*(:?\\.\\d+)? ?))\\]$"
                            )
                        ],
                    ),
                ),
                ("range_min", models.SmallIntegerField(default=0)),
                ("range_max", models.SmallIntegerField(default=4095)),
                ("relative", models.BooleanField(default=False)),
                (
                    "color_interpolation",
                    models.CharField(
                        choices=[
                            ("RGB", "RGB"),
                            ("HLS", "HLS"),
                            ("HLSpos", "HLS Positive"),
                            ("HLSneg", "HLS Negative"),
                            ("Constant", "Constant"),
                        ],
                        default="RGB",
                        max_length=8,
                    ),
                ),
                (
                    "color_interpolation_invert",
                    models.CharField(
                        choices=[
                            ("RGB", "RGB"),
                            ("HLS", "HLS"),
                            ("HLSpos", "HLS Positive"),
                            ("HLSneg", "HLS Negative"),
                            ("Constant", "Constant"),
                        ],
                        default="RGB",
                        max_length=8,
                    ),
                ),
            ],
            options={"ordering": ("title",), "abstract": False},
        ),
        migrations.CreateModel(
            name="WindowPreset",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "title",
                    models.CharField(max_length=255, verbose_name="title"),
                ),
                (
                    "description",
                    models.TextField(
                        blank=True, null=True, verbose_name="description"
                    ),
                ),
                (
                    "slug",
                    django_extensions.db.fields.AutoSlugField(
                        blank=True,
                        editable=False,
                        populate_from="title",
                        verbose_name="slug",
                    ),
                ),
                (
                    "width",
                    models.PositiveIntegerField(
                        validators=[
                            django.core.validators.MinValueValidator(
                                limit_value=1
                            )
                        ]
                    ),
                ),
                ("center", models.IntegerField()),
            ],
            options={"ordering": ("title",), "abstract": False},
        ),
        migrations.CreateModel(
            name="WorkstationConfig",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True)),
                ("modified", models.DateTimeField(auto_now=True)),
                (
                    "title",
                    models.CharField(max_length=255, verbose_name="title"),
                ),
                (
                    "description",
                    models.TextField(
                        blank=True, null=True, verbose_name="description"
                    ),
                ),
                (
                    "slug",
                    django_extensions.db.fields.AutoSlugField(
                        blank=True,
                        editable=False,
                        populate_from="title",
                        verbose_name="slug",
                    ),
                ),
                (
                    "default_slab_thickness_mm",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        max_digits=4,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(
                                limit_value=0.01
                            )
                        ],
                    ),
                ),
                (
                    "default_slab_render_method",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("MAX", "Maximum"),
                            ("MIN", "Minimum"),
                            ("AVG", "Average"),
                        ],
                        max_length=3,
                    ),
                ),
                (
                    "default_orientation",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("A", "Axial"),
                            ("C", "Coronal"),
                            ("S", "Sagittal"),
                        ],
                        max_length=1,
                    ),
                ),
                (
                    "default_overlay_interpolation",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("NN", "NearestNeighbor"),
                            ("TL", "Trilinear"),
                        ],
                        default="NN",
                        max_length=2,
                    ),
                ),
                ("show_image_info_plugin", models.BooleanField(default=True)),
                ("show_display_plugin", models.BooleanField(default=True)),
                (
                    "creator",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "default_overlay_lut",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="workstation_configs.lookuptable",
                    ),
                ),
                (
                    "default_window_preset",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="workstation_default_window_presets",
                        to="workstation_configs.windowpreset",
                    ),
                ),
                (
                    "window_presets",
                    models.ManyToManyField(
                        blank=True,
                        related_name="workstation_window_presets",
                        to="workstation_configs.WindowPreset",
                    ),
                ),
                (
                    "default_overlay_alpha",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        max_digits=3,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(
                                limit_value=0.0
                            ),
                            django.core.validators.MaxValueValidator(
                                limit_value=1.0
                            ),
                        ],
                    ),
                ),
                (
                    "default_zoom_scale",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        max_digits=4,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(
                                limit_value=0.01
                            )
                        ],
                    ),
                ),
                ("show_flip_tool", models.BooleanField(default=True)),
                ("show_invert_tool", models.BooleanField(default=True)),
                ("show_reset_tool", models.BooleanField(default=True)),
                ("show_window_level_tool", models.BooleanField(default=True)),
                (
                    "overlay_segments",
                    models.JSONField(
                        blank=True,
                        default=list,
                        validators=[
                            grandchallenge.core.validators.JSONValidator(
                                schema={
                                    "$id": "http://example.com/example.json",
                                    "$schema": "http://json-schema.org/draft-06/schema",
                                    "description": "Define the overlay segments for the LUT.",
                                    "items": {
                                        "$id": "#/items",
                                        "additionalProperties": False,
                                        "default": {},
                                        "description": "Defines what each segment of the LUT represents.",
                                        "examples": [
                                            {
                                                "metric_template": "{{metrics.volumes[0]}} mm³",
                                                "name": "Metastasis",
                                                "visible": True,
                                                "voxel_value": 1,
                                            }
                                        ],
                                        "properties": {
                                            "metric_template": {
                                                "$id": "#/items/properties/metric_template",
                                                "default": "",
                                                "description": "The jinja template to determine which property from the results.json should be used as the label text.",
                                                "examples": [
                                                    "{{metrics.volumes[0]}} mm³"
                                                ],
                                                "title": "The Metric Template Schema",
                                                "type": "string",
                                            },
                                            "name": {
                                                "$id": "#/items/properties/name",
                                                "default": "",
                                                "description": "What this segment should be called.",
                                                "examples": ["Metastasis"],
                                                "title": "The Name Schema",
                                                "type": "string",
                                            },
                                            "visible": {
                                                "$id": "#/items/properties/visible",
                                                "default": True,
                                                "description": "Whether this segment is visible by default.",
                                                "examples": [True],
                                                "title": "The Visible Schema",
                                                "type": "boolean",
                                            },
                                            "voxel_value": {
                                                "$id": "#/items/properties/voxel_value",
                                                "default": 0,
                                                "description": "The value of the LUT for this segment.",
                                                "examples": [1],
                                                "title": "The Voxel Value Schema",
                                                "type": "integer",
                                            },
                                        },
                                        "required": [
                                            "voxel_value",
                                            "name",
                                            "visible",
                                        ],
                                        "title": "The Segment Schema",
                                        "type": "object",
                                    },
                                    "title": "The Overlay Segments Schema",
                                    "type": "array",
                                }
                            )
                        ],
                    ),
                ),
                (
                    "key_bindings",
                    models.JSONField(
                        blank=True,
                        default=list,
                        validators=[
                            grandchallenge.core.validators.JSONValidator(
                                schema={
                                    "$id": "http://example.com/example.json",
                                    "$schema": "http://json-schema.org/draft-06/schema",
                                    "description": "Define the key bindings for the workstation.",
                                    "items": {
                                        "$id": "#/items",
                                        "additionalProperties": False,
                                        "default": {},
                                        "description": "Defines a key binding for a command.",
                                        "examples": [
                                            {
                                                "command": "editor.action.deleteLines",
                                                "key": "ctrl+shift+k",
                                                "when": "editorTextFocus",
                                            }
                                        ],
                                        "properties": {
                                            "command": {
                                                "$id": "#/items/properties/command",
                                                "default": "",
                                                "description": "The command called by this binding.",
                                                "examples": [
                                                    "editor.action.deleteLines"
                                                ],
                                                "title": "The Command Schema",
                                                "type": "string",
                                            },
                                            "key": {
                                                "$id": "#/items/properties/key",
                                                "default": "",
                                                "description": "The keys used for this binding.",
                                                "examples": ["ctrl+shift+k"],
                                                "title": "The Key Schema",
                                                "type": "string",
                                            },
                                            "when": {
                                                "$id": "#/items/properties/when",
                                                "default": "",
                                                "description": "The condition that must be met for this command to be called.",
                                                "examples": [
                                                    "editorTextFocus"
                                                ],
                                                "title": "The When Schema",
                                                "type": "string",
                                            },
                                        },
                                        "required": ["key", "command"],
                                        "title": "The Key Binding Schema",
                                        "type": "object",
                                    },
                                    "title": "The Key Bindings Schema",
                                    "type": "array",
                                }
                            )
                        ],
                    ),
                ),
            ],
            options={"ordering": ("created", "creator"), "abstract": False},
        ),
    ]
