# Generated by Django 3.1.8 on 2021-04-23 10:11

import uuid

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ("evaluation", "0004_auto_20210402_1508"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="WorkspaceTypeConfiguration",
            fields=[
                (
                    "service_workbench_id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("instance_type", models.CharField(max_length=16)),
                (
                    "auto_stop_time",
                    models.PositiveSmallIntegerField(default=10),
                ),
                (
                    "kind",
                    models.CharField(
                        choices=[
                            ("SAGEMAKER_NOTEBOOK", "SageMaker Notebook"),
                            ("EC2_LINUX", "EC2 Linux"),
                        ],
                        max_length=18,
                    ),
                ),
                (
                    "enabled_phases",
                    models.ManyToManyField(
                        blank=True,
                        related_name="enabled_workspace_type_configurations",
                        to="evaluation.Phase",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="Workspace",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True)),
                ("modified", models.DateTimeField(auto_now=True)),
                (
                    "service_workbench_id",
                    models.UUIDField(default=None, editable=False, null=True),
                ),
                ("allowed_ip", models.GenericIPAddressField()),
                ("notebook_url", models.TextField(blank=True, editable=False)),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("QUEUED", "Queued"),
                            ("PENDING", "Pending"),
                            ("TAINTED", "Tainted"),
                            ("FAILED", "Failed"),
                            ("COMPLETED", "Available"),
                            ("STARTING", "Starting"),
                            ("STARTING_FAILED", "Starting Failed"),
                            ("STOPPED", "Stopped"),
                            ("STOPPING", "Stopping"),
                            ("STOPPING_FAILED", "Stopping Failed"),
                            ("TERMINATING", "Terminating"),
                            ("TERMINATED", "Terminated"),
                            ("TERMINATING_FAILED", "Terminating Failed"),
                        ],
                        default="QUEUED",
                        max_length=18,
                    ),
                ),
                (
                    "configuration",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="workspaces.workspacetypeconfiguration",
                    ),
                ),
                (
                    "phase",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="evaluation.phase",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={"abstract": False},
        ),
        migrations.CreateModel(
            name="WorkbenchToken",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("email", models.EmailField(editable=False, max_length=254)),
                (
                    "_token",
                    models.TextField(db_column="token", editable=False),
                ),
                (
                    "provider",
                    models.CharField(
                        choices=[("INTERNAL", "Internal")],
                        default="INTERNAL",
                        editable=False,
                        max_length=8,
                    ),
                ),
                (
                    "user",
                    models.OneToOneField(
                        editable=False,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="workbench_token",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
        ),
    ]
