from django.urls import path

from grandchallenge.reader_studies.views import (
    AddDisplaySetsToReaderStudy,
    AddDisplaySetToReaderStudy,
    AddGroundTruthToReaderStudy,
    AddImagesToReaderStudy,
    AddQuestionToReaderStudy,
    AnswersRemoveForUser,
    AnswersRemoveGroundTruth,
    DisplaySetDetail,
    DisplaySetFilesUpdate,
    DisplaySetInterfacesCreate,
    DisplaySetUpdate,
    EditorsUpdate,
    QuestionDelete,
    QuestionInterfacesView,
    QuestionUpdate,
    QuestionWidgetsView,
    ReaderStudyCopy,
    ReaderStudyCreate,
    ReaderStudyDelete,
    ReaderStudyDetail,
    ReaderStudyDisplaySetList,
    ReaderStudyExampleGroundTruth,
    ReaderStudyLeaderBoard,
    ReaderStudyList,
    ReaderStudyPermissionRequestCreate,
    ReaderStudyPermissionRequestList,
    ReaderStudyPermissionRequestUpdate,
    ReaderStudyStatistics,
    ReaderStudyUpdate,
    ReadersUpdate,
    UsersProgress,
)

app_name = "reader-studies"

urlpatterns = [
    path("", ReaderStudyList.as_view(), name="list"),
    path("create/", ReaderStudyCreate.as_view(), name="create"),
    path(
        "questions/interfaces/",
        QuestionInterfacesView.as_view(),
        name="question-interfaces",
    ),
    path(
        "questions/widgets/",
        QuestionWidgetsView.as_view(),
        name="question-widgets",
    ),
    path("<slug>/", ReaderStudyDetail.as_view(), name="detail"),
    path("<slug>/update/", ReaderStudyUpdate.as_view(), name="update"),
    path("<slug>/delete/", ReaderStudyDelete.as_view(), name="delete"),
    path(
        "<slug>/leaderboard/",
        ReaderStudyLeaderBoard.as_view(),
        name="leaderboard",
    ),
    path(
        "<slug>/display-sets/",
        ReaderStudyDisplaySetList.as_view(),
        name="display_sets",
    ),
    path(
        "<slug>/statistics/",
        ReaderStudyStatistics.as_view(),
        name="statistics",
    ),
    path("<slug>/copy/", ReaderStudyCopy.as_view(), name="copy"),
    path(
        "<slug>/remove-answers/<username>/",
        AnswersRemoveForUser.as_view(),
        name="answers-remove",
    ),
    path(
        "<slug>/remove-ground-truth/",
        AnswersRemoveGroundTruth.as_view(),
        name="ground-truth-remove",
    ),
    path(
        "<slug>/ground-truth/add/",
        AddGroundTruthToReaderStudy.as_view(),
        name="add-ground-truth",
    ),
    path(
        "<slug>/ground-truth/example/",
        ReaderStudyExampleGroundTruth.as_view(),
        name="example-ground-truth",
    ),
    path(
        "<slug>/display-sets/create/",
        AddDisplaySetsToReaderStudy.as_view(),
        name="display-sets-create",
    ),
    path(
        "<slug>/display-sets/create-single/",
        AddDisplaySetToReaderStudy.as_view(),
        name="display-set-create",
    ),
    path(
        "<slug>/display-sets/<uuid:pk>/",
        DisplaySetDetail.as_view(),
        name="display-set-detail",
    ),
    path(
        "<slug>/display-sets/<uuid:pk>/update/",
        DisplaySetUpdate.as_view(),
        name="display-set-update",
    ),
    path(
        "<slug>/display-sets/new/interfaces/create/",
        DisplaySetInterfacesCreate.as_view(),
        name="display-set-new-interfaces-create",
    ),
    path(
        "<slug>/display-sets/<uuid:pk>/interface/create/",
        DisplaySetInterfacesCreate.as_view(),
        name="display-set-interfaces-create",
    ),
    path(
        "<slug>/display-sets/<uuid:pk>/interfaces/<slug:interface_slug>/files/update/",
        DisplaySetFilesUpdate.as_view(),
        name="display-set-files-update",
    ),
    path(
        "<slug>/images/add/",
        AddImagesToReaderStudy.as_view(),
        name="add-images",
    ),
    path(
        "<slug>/questions/add/",
        AddQuestionToReaderStudy.as_view(),
        name="add-question",
    ),
    path(
        "<slug>/questions/<pk>/update/",
        QuestionUpdate.as_view(),
        name="question-update",
    ),
    path(
        "<slug>/questions/<pk>/delete/",
        QuestionDelete.as_view(),
        name="question-delete",
    ),
    path(
        "<slug>/editors/update/",
        EditorsUpdate.as_view(),
        name="editors-update",
    ),
    path(
        "<slug>/readers/update/",
        ReadersUpdate.as_view(),
        name="readers-update",
    ),
    path("<slug>/progress/", UsersProgress.as_view(), name="users-progress"),
    path(
        "<slug>/permission-requests/",
        ReaderStudyPermissionRequestList.as_view(),
        name="permission-request-list",
    ),
    path(
        "<slug>/permission-requests/create/",
        ReaderStudyPermissionRequestCreate.as_view(),
        name="permission-request-create",
    ),
    path(
        "<slug>/permission-requests/<int:pk>/update/",
        ReaderStudyPermissionRequestUpdate.as_view(),
        name="permission-request-update",
    ),
]
