# Generated by Django 4.1.9 on 2023-06-29 09:09

import django.core.validators
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ("reader_studies", "0044_alter_question_widget"),
    ]

    operations = [
        migrations.AlterField(
            model_name="question",
            name="widget",
            field=models.CharField(
                blank=True,
                choices=[
                    ("ACCEPT_REJECT", "Accept/Reject Findings"),
                    ("NUMBER_INPUT", "Number input"),
                    ("NUMBER_RANGE", "Number Range"),
                    ("TEXT_INPUT", "Text Input"),
                    ("TEXT_AREA", "Text Area"),
                    ("SELECT_MULTIPLE", "Select Multiple"),
                    ("CHECKBOX_SELECT_MULTIPLE", "Checkbox Select Multiple"),
                    ("SELECT", "Select"),
                    ("RADIO_SELECT", "Radio Select"),
                ],
                max_length=24,
            ),
        ),
        migrations.AlterField(
            model_name="question",
            name="answer_max_value",
            field=models.SmallIntegerField(
                blank=True,
                default=None,
                help_text="Maximum value for answers of type Number. Can only be set in combination with the 'Number input' or 'Number Range' widgets.",
                null=True,
            ),
        ),
        migrations.AlterField(
            model_name="question",
            name="answer_min_value",
            field=models.SmallIntegerField(
                blank=True,
                default=None,
                help_text="Minimum value for answers of type Number. Can only be set in combination with the 'Number input' or 'Number Range' widgets.",
                null=True,
            ),
        ),
        migrations.AlterField(
            model_name="question",
            name="answer_step_size",
            field=models.DecimalField(
                blank=True,
                decimal_places=3,
                default=None,
                help_text="Step size for answers of type Number. Defaults to 1, allowing only integer values. Can only be set in combination with the 'Number input' or 'Number Range' widgets.",
                max_digits=6,
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(limit_value=0.001)
                ],
            ),
        ),
    ]
