# Generated by Django 4.1.9 on 2023-06-07 17:48

from django.db import migrations, models

import grandchallenge.core.validators


class Migration(migrations.Migration):

    dependencies = [
        ("reader_studies", "0040_auto_20230328_1106"),
    ]

    operations = [
        migrations.AlterField(
            model_name="answer",
            name="answer",
            field=models.JSONField(
                null=True,
                validators=[
                    grandchallenge.core.validators.JSONValidator(
                        schema={
                            "$schema": "http://json-schema.org/draft-07/schema#",
                            "anyOf": [
                                {"$ref": "#/definitions/null"},
                                {"$ref": "#/definitions/STXT"},
                                {"$ref": "#/definitions/MTXT"},
                                {"$ref": "#/definitions/BOOL"},
                                {"$ref": "#/definitions/NUMB"},
                                {"$ref": "#/definitions/HEAD"},
                                {"$ref": "#/definitions/2DBB"},
                                {"$ref": "#/definitions/DIST"},
                                {"$ref": "#/definitions/MDIS"},
                                {"$ref": "#/definitions/POIN"},
                                {"$ref": "#/definitions/MPOI"},
                                {"$ref": "#/definitions/POLY"},
                                {"$ref": "#/definitions/MPOL"},
                                {"$ref": "#/definitions/CHOI"},
                                {"$ref": "#/definitions/MCHO"},
                                {"$ref": "#/definitions/MCHD"},
                                {"$ref": "#/definitions/M2DB"},
                                {"$ref": "#/definitions/MASK"},
                                {"$ref": "#/definitions/LINE"},
                                {"$ref": "#/definitions/MLIN"},
                                {"$ref": "#/definitions/ANGL"},
                                {"$ref": "#/definitions/MANG"},
                                {"$ref": "#/definitions/ELLI"},
                                {"$ref": "#/definitions/MELL"},
                            ],
                            "definitions": {
                                "2D-bounding-box-object": {
                                    "additionalProperties": False,
                                    "properties": {
                                        "corners": {
                                            "items": {
                                                "items": {"type": "number"},
                                                "maxItems": 3,
                                                "minItems": 3,
                                                "type": "array",
                                            },
                                            "maxItems": 4,
                                            "minItems": 4,
                                            "type": "array",
                                        },
                                        "name": {"type": "string"},
                                        "probability": {
                                            "maximum": 1,
                                            "minimum": 0,
                                            "type": "number",
                                        },
                                        "type": {"enum": ["2D bounding box"]},
                                    },
                                    "required": ["corners"],
                                    "type": "object",
                                },
                                "2DBB": {
                                    "additionalProperties": False,
                                    "properties": {
                                        "corners": {
                                            "items": {
                                                "items": {"type": "number"},
                                                "maxItems": 3,
                                                "minItems": 3,
                                                "type": "array",
                                            },
                                            "maxItems": 4,
                                            "minItems": 4,
                                            "type": "array",
                                        },
                                        "name": {"type": "string"},
                                        "probability": {
                                            "maximum": 1,
                                            "minimum": 0,
                                            "type": "number",
                                        },
                                        "type": {"enum": ["2D bounding box"]},
                                        "version": {
                                            "$ref": "#/definitions/version-object"
                                        },
                                    },
                                    "required": ["version", "type", "corners"],
                                    "type": "object",
                                },
                                "ANGL": {
                                    "additionalProperties": False,
                                    "properties": {
                                        "lines": {
                                            "items": {
                                                "items": {
                                                    "items": {
                                                        "type": "number"
                                                    },
                                                    "maxItems": 3,
                                                    "minItems": 3,
                                                    "type": "array",
                                                },
                                                "maxItems": 2,
                                                "minItems": 2,
                                                "type": "array",
                                            },
                                            "maxItems": 2,
                                            "minItems": 2,
                                            "type": "array",
                                        },
                                        "name": {"type": "string"},
                                        "probability": {
                                            "maximum": 1,
                                            "minimum": 0,
                                            "type": "number",
                                        },
                                        "type": {"enum": ["Angle"]},
                                        "version": {
                                            "$ref": "#/definitions/version-object"
                                        },
                                    },
                                    "required": ["lines", "version", "type"],
                                    "type": "object",
                                },
                                "BOOL": {"type": "boolean"},
                                "CHOI": {"type": "number"},
                                "DIST": {
                                    "additionalProperties": False,
                                    "properties": {
                                        "end": {
                                            "items": {"type": "number"},
                                            "maxItems": 3,
                                            "minItems": 3,
                                            "type": "array",
                                        },
                                        "name": {"type": "string"},
                                        "probability": {
                                            "maximum": 1,
                                            "minimum": 0,
                                            "type": "number",
                                        },
                                        "start": {
                                            "items": {"type": "number"},
                                            "maxItems": 3,
                                            "minItems": 3,
                                            "type": "array",
                                        },
                                        "type": {
                                            "enum": ["Distance measurement"]
                                        },
                                        "version": {
                                            "$ref": "#/definitions/version-object"
                                        },
                                    },
                                    "required": [
                                        "version",
                                        "type",
                                        "start",
                                        "end",
                                    ],
                                    "type": "object",
                                },
                                "ELLI": {
                                    "additionalProperties": False,
                                    "properties": {
                                        "major_axis": {
                                            "items": {
                                                "items": {"type": "number"},
                                                "maxItems": 3,
                                                "minItems": 3,
                                                "type": "array",
                                            },
                                            "maxItems": 2,
                                            "minItems": 2,
                                            "type": "array",
                                        },
                                        "minor_axis": {
                                            "items": {
                                                "items": {"type": "number"},
                                                "maxItems": 3,
                                                "minItems": 3,
                                                "type": "array",
                                            },
                                            "maxItems": 2,
                                            "minItems": 2,
                                            "type": "array",
                                        },
                                        "name": {"type": "string"},
                                        "probability": {
                                            "maximum": 1,
                                            "minimum": 0,
                                            "type": "number",
                                        },
                                        "type": {"enum": ["Ellipse"]},
                                        "version": {
                                            "$ref": "#/definitions/version-object"
                                        },
                                    },
                                    "required": [
                                        "version",
                                        "type",
                                        "major_axis",
                                        "minor_axis",
                                    ],
                                    "type": "object",
                                },
                                "HEAD": {"type": "null"},
                                "LINE": {
                                    "additionalProperties": False,
                                    "properties": {
                                        "name": {"type": "string"},
                                        "path_point_lists": {
                                            "items": {
                                                "items": {
                                                    "items": {
                                                        "type": "number"
                                                    },
                                                    "maxItems": 3,
                                                    "minItems": 3,
                                                    "type": "array",
                                                },
                                                "type": "array",
                                            },
                                            "type": "array",
                                        },
                                        "probability": {
                                            "maximum": 1,
                                            "minimum": 0,
                                            "type": "number",
                                        },
                                        "seed_points": {
                                            "items": {
                                                "items": {"type": "number"},
                                                "maxItems": 3,
                                                "minItems": 3,
                                                "type": "array",
                                            },
                                            "type": "array",
                                        },
                                        "type": {"enum": ["Line"]},
                                        "version": {
                                            "$ref": "#/definitions/version-object"
                                        },
                                    },
                                    "required": [
                                        "seed_points",
                                        "path_point_lists",
                                        "type",
                                        "version",
                                    ],
                                    "type": "object",
                                },
                                "M2DB": {
                                    "additionalProperties": False,
                                    "properties": {
                                        "boxes": {
                                            "items": {
                                                "allOf": [
                                                    {
                                                        "$ref": "#/definitions/2D-bounding-box-object"
                                                    }
                                                ]
                                            },
                                            "type": "array",
                                        },
                                        "name": {"type": "string"},
                                        "type": {
                                            "enum": [
                                                "Multiple 2D bounding boxes"
                                            ]
                                        },
                                        "version": {
                                            "$ref": "#/definitions/version-object"
                                        },
                                    },
                                    "required": ["version", "type", "boxes"],
                                    "type": "object",
                                },
                                "MANG": {
                                    "additionalProperties": False,
                                    "properties": {
                                        "angles": {
                                            "items": {
                                                "$ref": "#/definitions/angle-object"
                                            },
                                            "type": "array",
                                        },
                                        "name": {"type": "string"},
                                        "type": {"enum": ["Multiple angles"]},
                                        "version": {
                                            "$ref": "#/definitions/version-object"
                                        },
                                    },
                                    "required": ["type", "version", "angles"],
                                    "type": "object",
                                },
                                "MASK": {
                                    "additionalProperties": False,
                                    "properties": {
                                        "upload_session_pk": {
                                            "format": "uuid",
                                            "type": "string",
                                        }
                                    },
                                    "required": ["upload_session_pk"],
                                    "type": "object",
                                },
                                "MCHD": {
                                    "items": {"type": "number"},
                                    "type": "array",
                                },
                                "MCHO": {
                                    "items": {"type": "number"},
                                    "type": "array",
                                },
                                "MDIS": {
                                    "additionalProperties": False,
                                    "properties": {
                                        "lines": {
                                            "items": {
                                                "allOf": [
                                                    {
                                                        "$ref": "#/definitions/line-object"
                                                    }
                                                ]
                                            },
                                            "type": "array",
                                        },
                                        "name": {"type": "string"},
                                        "type": {
                                            "enum": [
                                                "Multiple distance measurements"
                                            ]
                                        },
                                        "version": {
                                            "$ref": "#/definitions/version-object"
                                        },
                                    },
                                    "required": ["version", "type", "lines"],
                                    "type": "object",
                                },
                                "MELL": {
                                    "additionalProperties": False,
                                    "properties": {
                                        "ellipses": {
                                            "items": {
                                                "allOf": [
                                                    {
                                                        "$ref": "#/definitions/ellipse-object"
                                                    }
                                                ]
                                            },
                                            "type": "array",
                                        },
                                        "name": {"type": "string"},
                                        "type": {
                                            "enum": ["Multiple ellipses"]
                                        },
                                        "version": {
                                            "$ref": "#/definitions/version-object"
                                        },
                                    },
                                    "required": [
                                        "version",
                                        "type",
                                        "ellipses",
                                    ],
                                    "type": "object",
                                },
                                "MLIN": {
                                    "additionalProperties": False,
                                    "properties": {
                                        "lines": {
                                            "items": {
                                                "$ref": "#/definitions/spline-object"
                                            },
                                            "type": "array",
                                        },
                                        "name": {"type": "string"},
                                        "type": {"enum": ["Multiple lines"]},
                                        "version": {
                                            "$ref": "#/definitions/version-object"
                                        },
                                    },
                                    "required": ["type", "version", "lines"],
                                    "type": "object",
                                },
                                "MPOI": {
                                    "additionalProperties": False,
                                    "properties": {
                                        "name": {"type": "string"},
                                        "points": {
                                            "items": {
                                                "allOf": [
                                                    {
                                                        "$ref": "#/definitions/point-object"
                                                    }
                                                ]
                                            },
                                            "type": "array",
                                        },
                                        "type": {"enum": ["Multiple points"]},
                                        "version": {
                                            "$ref": "#/definitions/version-object"
                                        },
                                    },
                                    "required": ["version", "type", "points"],
                                    "type": "object",
                                },
                                "MPOL": {
                                    "additionalProperties": False,
                                    "properties": {
                                        "name": {"type": "string"},
                                        "polygons": {
                                            "items": {
                                                "$ref": "#/definitions/polygon-object"
                                            },
                                            "type": "array",
                                        },
                                        "type": {
                                            "enum": ["Multiple polygons"]
                                        },
                                        "version": {
                                            "$ref": "#/definitions/version-object"
                                        },
                                    },
                                    "required": [
                                        "type",
                                        "version",
                                        "polygons",
                                    ],
                                    "type": "object",
                                },
                                "MTXT": {"type": "string"},
                                "NUMB": {"type": "number"},
                                "POIN": {
                                    "additionalProperties": False,
                                    "properties": {
                                        "name": {"type": "string"},
                                        "point": {
                                            "items": {"type": "number"},
                                            "maxItems": 3,
                                            "minItems": 3,
                                            "type": "array",
                                        },
                                        "probability": {
                                            "maximum": 1,
                                            "minimum": 0,
                                            "type": "number",
                                        },
                                        "type": {"enum": ["Point"]},
                                        "version": {
                                            "$ref": "#/definitions/version-object"
                                        },
                                    },
                                    "required": ["version", "type", "point"],
                                    "type": "object",
                                },
                                "POLY": {
                                    "additionalProperties": False,
                                    "properties": {
                                        "groups": {
                                            "items": {"type": "string"},
                                            "type": "array",
                                        },
                                        "name": {"type": "string"},
                                        "path_points": {
                                            "items": {
                                                "items": {"type": "number"},
                                                "maxItems": 3,
                                                "minItems": 3,
                                                "type": "array",
                                            },
                                            "type": "array",
                                        },
                                        "probability": {
                                            "maximum": 1,
                                            "minimum": 0,
                                            "type": "number",
                                        },
                                        "seed_point": {
                                            "items": {"type": "number"},
                                            "maxItems": 3,
                                            "minItems": 3,
                                            "type": "array",
                                        },
                                        "sub_type": {"type": "string"},
                                        "type": {"enum": ["Polygon"]},
                                        "version": {
                                            "$ref": "#/definitions/version-object"
                                        },
                                    },
                                    "required": [
                                        "seed_point",
                                        "path_points",
                                        "sub_type",
                                        "groups",
                                        "type",
                                        "version",
                                    ],
                                    "type": "object",
                                },
                                "STXT": {"type": "string"},
                                "TEXT": {"type": "string"},
                                "angle-object": {
                                    "additionalProperties": False,
                                    "properties": {
                                        "lines": {
                                            "items": {
                                                "items": {
                                                    "items": {
                                                        "type": "number"
                                                    },
                                                    "maxItems": 3,
                                                    "minItems": 3,
                                                    "type": "array",
                                                },
                                                "maxItems": 2,
                                                "minItems": 2,
                                                "type": "array",
                                            },
                                            "maxItems": 2,
                                            "minItems": 2,
                                            "type": "array",
                                        },
                                        "name": {"type": "string"},
                                        "probability": {
                                            "maximum": 1,
                                            "minimum": 0,
                                            "type": "number",
                                        },
                                        "type": {"enum": ["Angle"]},
                                    },
                                    "required": ["lines"],
                                    "type": "object",
                                },
                                "ellipse-object": {
                                    "additionalProperties": False,
                                    "properties": {
                                        "major_axis": {
                                            "items": {
                                                "items": {"type": "number"},
                                                "maxItems": 3,
                                                "minItems": 3,
                                                "type": "array",
                                            },
                                            "maxItems": 2,
                                            "minItems": 2,
                                            "type": "array",
                                        },
                                        "minor_axis": {
                                            "items": {
                                                "items": {"type": "number"},
                                                "maxItems": 3,
                                                "minItems": 3,
                                                "type": "array",
                                            },
                                            "maxItems": 2,
                                            "minItems": 2,
                                            "type": "array",
                                        },
                                        "name": {"type": "string"},
                                        "probability": {
                                            "maximum": 1,
                                            "minimum": 0,
                                            "type": "number",
                                        },
                                        "type": {"enum": ["Ellipse"]},
                                    },
                                    "required": ["major_axis", "minor_axis"],
                                    "type": "object",
                                },
                                "line-object": {
                                    "additionalProperties": False,
                                    "properties": {
                                        "end": {
                                            "items": {"type": "number"},
                                            "maxItems": 3,
                                            "minItems": 3,
                                            "type": "array",
                                        },
                                        "name": {"type": "string"},
                                        "probability": {
                                            "maximum": 1,
                                            "minimum": 0,
                                            "type": "number",
                                        },
                                        "start": {
                                            "items": {"type": "number"},
                                            "maxItems": 3,
                                            "minItems": 3,
                                            "type": "array",
                                        },
                                        "type": {
                                            "enum": ["Distance measurement"]
                                        },
                                    },
                                    "required": ["start", "end"],
                                    "type": "object",
                                },
                                "null": {"type": "null"},
                                "point-object": {
                                    "additionalProperties": False,
                                    "properties": {
                                        "name": {"type": "string"},
                                        "point": {
                                            "items": {"type": "number"},
                                            "maxItems": 3,
                                            "minItems": 3,
                                            "type": "array",
                                        },
                                        "probability": {
                                            "maximum": 1,
                                            "minimum": 0,
                                            "type": "number",
                                        },
                                        "type": {"enum": ["Point"]},
                                    },
                                    "required": ["point"],
                                    "type": "object",
                                },
                                "polygon-object": {
                                    "additionalProperties": False,
                                    "properties": {
                                        "groups": {
                                            "items": {"type": "string"},
                                            "type": "array",
                                        },
                                        "name": {"type": "string"},
                                        "path_points": {
                                            "items": {
                                                "items": {"type": "number"},
                                                "maxItems": 3,
                                                "minItems": 3,
                                                "type": "array",
                                            },
                                            "type": "array",
                                        },
                                        "probability": {
                                            "maximum": 1,
                                            "minimum": 0,
                                            "type": "number",
                                        },
                                        "seed_point": {
                                            "items": {"type": "number"},
                                            "maxItems": 3,
                                            "minItems": 3,
                                            "type": "array",
                                        },
                                        "sub_type": {"type": "string"},
                                        "type": {"enum": ["Polygon"]},
                                    },
                                    "required": [
                                        "seed_point",
                                        "path_points",
                                        "sub_type",
                                        "groups",
                                    ],
                                    "type": "object",
                                },
                                "spline-object": {
                                    "additionalProperties": False,
                                    "properties": {
                                        "name": {"type": "string"},
                                        "path_point_lists": {
                                            "items": {
                                                "items": {
                                                    "items": {
                                                        "type": "number"
                                                    },
                                                    "maxItems": 3,
                                                    "minItems": 3,
                                                    "type": "array",
                                                },
                                                "type": "array",
                                            },
                                            "type": "array",
                                        },
                                        "probability": {
                                            "maximum": 1,
                                            "minimum": 0,
                                            "type": "number",
                                        },
                                        "seed_points": {
                                            "items": {
                                                "items": {"type": "number"},
                                                "maxItems": 3,
                                                "minItems": 3,
                                                "type": "array",
                                            },
                                            "type": "array",
                                        },
                                        "type": {"enum": ["Line"]},
                                    },
                                    "required": [
                                        "seed_points",
                                        "path_point_lists",
                                    ],
                                    "type": "object",
                                },
                                "version-object": {
                                    "additionalProperties": False,
                                    "properties": {
                                        "major": {
                                            "minimum": 0,
                                            "multipleOf": 1.0,
                                            "type": "number",
                                        },
                                        "minor": {
                                            "minimum": 0,
                                            "multipleOf": 1.0,
                                            "type": "number",
                                        },
                                    },
                                    "required": ["major", "minor"],
                                    "type": "object",
                                },
                            },
                        }
                    )
                ],
            ),
        ),
        migrations.AlterField(
            model_name="historicalanswer",
            name="answer",
            field=models.JSONField(
                null=True,
                validators=[
                    grandchallenge.core.validators.JSONValidator(
                        schema={
                            "$schema": "http://json-schema.org/draft-07/schema#",
                            "anyOf": [
                                {"$ref": "#/definitions/null"},
                                {"$ref": "#/definitions/STXT"},
                                {"$ref": "#/definitions/MTXT"},
                                {"$ref": "#/definitions/BOOL"},
                                {"$ref": "#/definitions/NUMB"},
                                {"$ref": "#/definitions/HEAD"},
                                {"$ref": "#/definitions/2DBB"},
                                {"$ref": "#/definitions/DIST"},
                                {"$ref": "#/definitions/MDIS"},
                                {"$ref": "#/definitions/POIN"},
                                {"$ref": "#/definitions/MPOI"},
                                {"$ref": "#/definitions/POLY"},
                                {"$ref": "#/definitions/MPOL"},
                                {"$ref": "#/definitions/CHOI"},
                                {"$ref": "#/definitions/MCHO"},
                                {"$ref": "#/definitions/MCHD"},
                                {"$ref": "#/definitions/M2DB"},
                                {"$ref": "#/definitions/MASK"},
                                {"$ref": "#/definitions/LINE"},
                                {"$ref": "#/definitions/MLIN"},
                                {"$ref": "#/definitions/ANGL"},
                                {"$ref": "#/definitions/MANG"},
                                {"$ref": "#/definitions/ELLI"},
                                {"$ref": "#/definitions/MELL"},
                            ],
                            "definitions": {
                                "2D-bounding-box-object": {
                                    "additionalProperties": False,
                                    "properties": {
                                        "corners": {
                                            "items": {
                                                "items": {"type": "number"},
                                                "maxItems": 3,
                                                "minItems": 3,
                                                "type": "array",
                                            },
                                            "maxItems": 4,
                                            "minItems": 4,
                                            "type": "array",
                                        },
                                        "name": {"type": "string"},
                                        "probability": {
                                            "maximum": 1,
                                            "minimum": 0,
                                            "type": "number",
                                        },
                                        "type": {"enum": ["2D bounding box"]},
                                    },
                                    "required": ["corners"],
                                    "type": "object",
                                },
                                "2DBB": {
                                    "additionalProperties": False,
                                    "properties": {
                                        "corners": {
                                            "items": {
                                                "items": {"type": "number"},
                                                "maxItems": 3,
                                                "minItems": 3,
                                                "type": "array",
                                            },
                                            "maxItems": 4,
                                            "minItems": 4,
                                            "type": "array",
                                        },
                                        "name": {"type": "string"},
                                        "probability": {
                                            "maximum": 1,
                                            "minimum": 0,
                                            "type": "number",
                                        },
                                        "type": {"enum": ["2D bounding box"]},
                                        "version": {
                                            "$ref": "#/definitions/version-object"
                                        },
                                    },
                                    "required": ["version", "type", "corners"],
                                    "type": "object",
                                },
                                "ANGL": {
                                    "additionalProperties": False,
                                    "properties": {
                                        "lines": {
                                            "items": {
                                                "items": {
                                                    "items": {
                                                        "type": "number"
                                                    },
                                                    "maxItems": 3,
                                                    "minItems": 3,
                                                    "type": "array",
                                                },
                                                "maxItems": 2,
                                                "minItems": 2,
                                                "type": "array",
                                            },
                                            "maxItems": 2,
                                            "minItems": 2,
                                            "type": "array",
                                        },
                                        "name": {"type": "string"},
                                        "probability": {
                                            "maximum": 1,
                                            "minimum": 0,
                                            "type": "number",
                                        },
                                        "type": {"enum": ["Angle"]},
                                        "version": {
                                            "$ref": "#/definitions/version-object"
                                        },
                                    },
                                    "required": ["lines", "version", "type"],
                                    "type": "object",
                                },
                                "BOOL": {"type": "boolean"},
                                "CHOI": {"type": "number"},
                                "DIST": {
                                    "additionalProperties": False,
                                    "properties": {
                                        "end": {
                                            "items": {"type": "number"},
                                            "maxItems": 3,
                                            "minItems": 3,
                                            "type": "array",
                                        },
                                        "name": {"type": "string"},
                                        "probability": {
                                            "maximum": 1,
                                            "minimum": 0,
                                            "type": "number",
                                        },
                                        "start": {
                                            "items": {"type": "number"},
                                            "maxItems": 3,
                                            "minItems": 3,
                                            "type": "array",
                                        },
                                        "type": {
                                            "enum": ["Distance measurement"]
                                        },
                                        "version": {
                                            "$ref": "#/definitions/version-object"
                                        },
                                    },
                                    "required": [
                                        "version",
                                        "type",
                                        "start",
                                        "end",
                                    ],
                                    "type": "object",
                                },
                                "ELLI": {
                                    "additionalProperties": False,
                                    "properties": {
                                        "major_axis": {
                                            "items": {
                                                "items": {"type": "number"},
                                                "maxItems": 3,
                                                "minItems": 3,
                                                "type": "array",
                                            },
                                            "maxItems": 2,
                                            "minItems": 2,
                                            "type": "array",
                                        },
                                        "minor_axis": {
                                            "items": {
                                                "items": {"type": "number"},
                                                "maxItems": 3,
                                                "minItems": 3,
                                                "type": "array",
                                            },
                                            "maxItems": 2,
                                            "minItems": 2,
                                            "type": "array",
                                        },
                                        "name": {"type": "string"},
                                        "probability": {
                                            "maximum": 1,
                                            "minimum": 0,
                                            "type": "number",
                                        },
                                        "type": {"enum": ["Ellipse"]},
                                        "version": {
                                            "$ref": "#/definitions/version-object"
                                        },
                                    },
                                    "required": [
                                        "version",
                                        "type",
                                        "major_axis",
                                        "minor_axis",
                                    ],
                                    "type": "object",
                                },
                                "HEAD": {"type": "null"},
                                "LINE": {
                                    "additionalProperties": False,
                                    "properties": {
                                        "name": {"type": "string"},
                                        "path_point_lists": {
                                            "items": {
                                                "items": {
                                                    "items": {
                                                        "type": "number"
                                                    },
                                                    "maxItems": 3,
                                                    "minItems": 3,
                                                    "type": "array",
                                                },
                                                "type": "array",
                                            },
                                            "type": "array",
                                        },
                                        "probability": {
                                            "maximum": 1,
                                            "minimum": 0,
                                            "type": "number",
                                        },
                                        "seed_points": {
                                            "items": {
                                                "items": {"type": "number"},
                                                "maxItems": 3,
                                                "minItems": 3,
                                                "type": "array",
                                            },
                                            "type": "array",
                                        },
                                        "type": {"enum": ["Line"]},
                                        "version": {
                                            "$ref": "#/definitions/version-object"
                                        },
                                    },
                                    "required": [
                                        "seed_points",
                                        "path_point_lists",
                                        "type",
                                        "version",
                                    ],
                                    "type": "object",
                                },
                                "M2DB": {
                                    "additionalProperties": False,
                                    "properties": {
                                        "boxes": {
                                            "items": {
                                                "allOf": [
                                                    {
                                                        "$ref": "#/definitions/2D-bounding-box-object"
                                                    }
                                                ]
                                            },
                                            "type": "array",
                                        },
                                        "name": {"type": "string"},
                                        "type": {
                                            "enum": [
                                                "Multiple 2D bounding boxes"
                                            ]
                                        },
                                        "version": {
                                            "$ref": "#/definitions/version-object"
                                        },
                                    },
                                    "required": ["version", "type", "boxes"],
                                    "type": "object",
                                },
                                "MANG": {
                                    "additionalProperties": False,
                                    "properties": {
                                        "angles": {
                                            "items": {
                                                "$ref": "#/definitions/angle-object"
                                            },
                                            "type": "array",
                                        },
                                        "name": {"type": "string"},
                                        "type": {"enum": ["Multiple angles"]},
                                        "version": {
                                            "$ref": "#/definitions/version-object"
                                        },
                                    },
                                    "required": ["type", "version", "angles"],
                                    "type": "object",
                                },
                                "MASK": {
                                    "additionalProperties": False,
                                    "properties": {
                                        "upload_session_pk": {
                                            "format": "uuid",
                                            "type": "string",
                                        }
                                    },
                                    "required": ["upload_session_pk"],
                                    "type": "object",
                                },
                                "MCHD": {
                                    "items": {"type": "number"},
                                    "type": "array",
                                },
                                "MCHO": {
                                    "items": {"type": "number"},
                                    "type": "array",
                                },
                                "MDIS": {
                                    "additionalProperties": False,
                                    "properties": {
                                        "lines": {
                                            "items": {
                                                "allOf": [
                                                    {
                                                        "$ref": "#/definitions/line-object"
                                                    }
                                                ]
                                            },
                                            "type": "array",
                                        },
                                        "name": {"type": "string"},
                                        "type": {
                                            "enum": [
                                                "Multiple distance measurements"
                                            ]
                                        },
                                        "version": {
                                            "$ref": "#/definitions/version-object"
                                        },
                                    },
                                    "required": ["version", "type", "lines"],
                                    "type": "object",
                                },
                                "MELL": {
                                    "additionalProperties": False,
                                    "properties": {
                                        "ellipses": {
                                            "items": {
                                                "allOf": [
                                                    {
                                                        "$ref": "#/definitions/ellipse-object"
                                                    }
                                                ]
                                            },
                                            "type": "array",
                                        },
                                        "name": {"type": "string"},
                                        "type": {
                                            "enum": ["Multiple ellipses"]
                                        },
                                        "version": {
                                            "$ref": "#/definitions/version-object"
                                        },
                                    },
                                    "required": [
                                        "version",
                                        "type",
                                        "ellipses",
                                    ],
                                    "type": "object",
                                },
                                "MLIN": {
                                    "additionalProperties": False,
                                    "properties": {
                                        "lines": {
                                            "items": {
                                                "$ref": "#/definitions/spline-object"
                                            },
                                            "type": "array",
                                        },
                                        "name": {"type": "string"},
                                        "type": {"enum": ["Multiple lines"]},
                                        "version": {
                                            "$ref": "#/definitions/version-object"
                                        },
                                    },
                                    "required": ["type", "version", "lines"],
                                    "type": "object",
                                },
                                "MPOI": {
                                    "additionalProperties": False,
                                    "properties": {
                                        "name": {"type": "string"},
                                        "points": {
                                            "items": {
                                                "allOf": [
                                                    {
                                                        "$ref": "#/definitions/point-object"
                                                    }
                                                ]
                                            },
                                            "type": "array",
                                        },
                                        "type": {"enum": ["Multiple points"]},
                                        "version": {
                                            "$ref": "#/definitions/version-object"
                                        },
                                    },
                                    "required": ["version", "type", "points"],
                                    "type": "object",
                                },
                                "MPOL": {
                                    "additionalProperties": False,
                                    "properties": {
                                        "name": {"type": "string"},
                                        "polygons": {
                                            "items": {
                                                "$ref": "#/definitions/polygon-object"
                                            },
                                            "type": "array",
                                        },
                                        "type": {
                                            "enum": ["Multiple polygons"]
                                        },
                                        "version": {
                                            "$ref": "#/definitions/version-object"
                                        },
                                    },
                                    "required": [
                                        "type",
                                        "version",
                                        "polygons",
                                    ],
                                    "type": "object",
                                },
                                "MTXT": {"type": "string"},
                                "NUMB": {"type": "number"},
                                "POIN": {
                                    "additionalProperties": False,
                                    "properties": {
                                        "name": {"type": "string"},
                                        "point": {
                                            "items": {"type": "number"},
                                            "maxItems": 3,
                                            "minItems": 3,
                                            "type": "array",
                                        },
                                        "probability": {
                                            "maximum": 1,
                                            "minimum": 0,
                                            "type": "number",
                                        },
                                        "type": {"enum": ["Point"]},
                                        "version": {
                                            "$ref": "#/definitions/version-object"
                                        },
                                    },
                                    "required": ["version", "type", "point"],
                                    "type": "object",
                                },
                                "POLY": {
                                    "additionalProperties": False,
                                    "properties": {
                                        "groups": {
                                            "items": {"type": "string"},
                                            "type": "array",
                                        },
                                        "name": {"type": "string"},
                                        "path_points": {
                                            "items": {
                                                "items": {"type": "number"},
                                                "maxItems": 3,
                                                "minItems": 3,
                                                "type": "array",
                                            },
                                            "type": "array",
                                        },
                                        "probability": {
                                            "maximum": 1,
                                            "minimum": 0,
                                            "type": "number",
                                        },
                                        "seed_point": {
                                            "items": {"type": "number"},
                                            "maxItems": 3,
                                            "minItems": 3,
                                            "type": "array",
                                        },
                                        "sub_type": {"type": "string"},
                                        "type": {"enum": ["Polygon"]},
                                        "version": {
                                            "$ref": "#/definitions/version-object"
                                        },
                                    },
                                    "required": [
                                        "seed_point",
                                        "path_points",
                                        "sub_type",
                                        "groups",
                                        "type",
                                        "version",
                                    ],
                                    "type": "object",
                                },
                                "STXT": {"type": "string"},
                                "TEXT": {"type": "string"},
                                "angle-object": {
                                    "additionalProperties": False,
                                    "properties": {
                                        "lines": {
                                            "items": {
                                                "items": {
                                                    "items": {
                                                        "type": "number"
                                                    },
                                                    "maxItems": 3,
                                                    "minItems": 3,
                                                    "type": "array",
                                                },
                                                "maxItems": 2,
                                                "minItems": 2,
                                                "type": "array",
                                            },
                                            "maxItems": 2,
                                            "minItems": 2,
                                            "type": "array",
                                        },
                                        "name": {"type": "string"},
                                        "probability": {
                                            "maximum": 1,
                                            "minimum": 0,
                                            "type": "number",
                                        },
                                        "type": {"enum": ["Angle"]},
                                    },
                                    "required": ["lines"],
                                    "type": "object",
                                },
                                "ellipse-object": {
                                    "additionalProperties": False,
                                    "properties": {
                                        "major_axis": {
                                            "items": {
                                                "items": {"type": "number"},
                                                "maxItems": 3,
                                                "minItems": 3,
                                                "type": "array",
                                            },
                                            "maxItems": 2,
                                            "minItems": 2,
                                            "type": "array",
                                        },
                                        "minor_axis": {
                                            "items": {
                                                "items": {"type": "number"},
                                                "maxItems": 3,
                                                "minItems": 3,
                                                "type": "array",
                                            },
                                            "maxItems": 2,
                                            "minItems": 2,
                                            "type": "array",
                                        },
                                        "name": {"type": "string"},
                                        "probability": {
                                            "maximum": 1,
                                            "minimum": 0,
                                            "type": "number",
                                        },
                                        "type": {"enum": ["Ellipse"]},
                                    },
                                    "required": ["major_axis", "minor_axis"],
                                    "type": "object",
                                },
                                "line-object": {
                                    "additionalProperties": False,
                                    "properties": {
                                        "end": {
                                            "items": {"type": "number"},
                                            "maxItems": 3,
                                            "minItems": 3,
                                            "type": "array",
                                        },
                                        "name": {"type": "string"},
                                        "probability": {
                                            "maximum": 1,
                                            "minimum": 0,
                                            "type": "number",
                                        },
                                        "start": {
                                            "items": {"type": "number"},
                                            "maxItems": 3,
                                            "minItems": 3,
                                            "type": "array",
                                        },
                                        "type": {
                                            "enum": ["Distance measurement"]
                                        },
                                    },
                                    "required": ["start", "end"],
                                    "type": "object",
                                },
                                "null": {"type": "null"},
                                "point-object": {
                                    "additionalProperties": False,
                                    "properties": {
                                        "name": {"type": "string"},
                                        "point": {
                                            "items": {"type": "number"},
                                            "maxItems": 3,
                                            "minItems": 3,
                                            "type": "array",
                                        },
                                        "probability": {
                                            "maximum": 1,
                                            "minimum": 0,
                                            "type": "number",
                                        },
                                        "type": {"enum": ["Point"]},
                                    },
                                    "required": ["point"],
                                    "type": "object",
                                },
                                "polygon-object": {
                                    "additionalProperties": False,
                                    "properties": {
                                        "groups": {
                                            "items": {"type": "string"},
                                            "type": "array",
                                        },
                                        "name": {"type": "string"},
                                        "path_points": {
                                            "items": {
                                                "items": {"type": "number"},
                                                "maxItems": 3,
                                                "minItems": 3,
                                                "type": "array",
                                            },
                                            "type": "array",
                                        },
                                        "probability": {
                                            "maximum": 1,
                                            "minimum": 0,
                                            "type": "number",
                                        },
                                        "seed_point": {
                                            "items": {"type": "number"},
                                            "maxItems": 3,
                                            "minItems": 3,
                                            "type": "array",
                                        },
                                        "sub_type": {"type": "string"},
                                        "type": {"enum": ["Polygon"]},
                                    },
                                    "required": [
                                        "seed_point",
                                        "path_points",
                                        "sub_type",
                                        "groups",
                                    ],
                                    "type": "object",
                                },
                                "spline-object": {
                                    "additionalProperties": False,
                                    "properties": {
                                        "name": {"type": "string"},
                                        "path_point_lists": {
                                            "items": {
                                                "items": {
                                                    "items": {
                                                        "type": "number"
                                                    },
                                                    "maxItems": 3,
                                                    "minItems": 3,
                                                    "type": "array",
                                                },
                                                "type": "array",
                                            },
                                            "type": "array",
                                        },
                                        "probability": {
                                            "maximum": 1,
                                            "minimum": 0,
                                            "type": "number",
                                        },
                                        "seed_points": {
                                            "items": {
                                                "items": {"type": "number"},
                                                "maxItems": 3,
                                                "minItems": 3,
                                                "type": "array",
                                            },
                                            "type": "array",
                                        },
                                        "type": {"enum": ["Line"]},
                                    },
                                    "required": [
                                        "seed_points",
                                        "path_point_lists",
                                    ],
                                    "type": "object",
                                },
                                "version-object": {
                                    "additionalProperties": False,
                                    "properties": {
                                        "major": {
                                            "minimum": 0,
                                            "multipleOf": 1.0,
                                            "type": "number",
                                        },
                                        "minor": {
                                            "minimum": 0,
                                            "multipleOf": 1.0,
                                            "type": "number",
                                        },
                                    },
                                    "required": ["major", "minor"],
                                    "type": "object",
                                },
                            },
                        }
                    )
                ],
            ),
        ),
        migrations.AlterField(
            model_name="question",
            name="answer_type",
            field=models.CharField(
                choices=[
                    ("TEXT", "Text"),
                    ("STXT", "Single line text"),
                    ("MTXT", "Multi line text"),
                    ("BOOL", "Bool"),
                    ("NUMB", "Number"),
                    ("HEAD", "Heading"),
                    ("2DBB", "2D bounding box"),
                    ("M2DB", "Multiple 2D bounding boxes"),
                    ("DIST", "Distance measurement"),
                    ("MDIS", "Multiple distance measurements"),
                    ("POIN", "Point"),
                    ("MPOI", "Multiple points"),
                    ("POLY", "Polygon"),
                    ("MPOL", "Multiple polygons"),
                    ("CHOI", "Choice"),
                    ("MCHO", "Multiple choice"),
                    ("MCHD", "Multiple choice dropdown"),
                    ("MASK", "Mask"),
                    ("LINE", "Line"),
                    ("MLIN", "Multiple lines"),
                    ("ANGL", "Angle"),
                    ("MANG", "Multiple angles"),
                    ("ELLI", "Ellipse"),
                    ("MELL", "Multiple ellipses"),
                ],
                default="STXT",
                max_length=4,
            ),
        ),
        migrations.AlterField(
            model_name="question",
            name="widget",
            field=models.CharField(
                blank=True,
                choices=[
                    ("ACCEPT_REJECT", "Accept/Reject Findings"),
                    ("NUMBER_INPUT", "Number input"),
                    ("TEXT_INPUT", "Text Input"),
                    ("TEXT_AREA", "Text Area"),
                ],
                max_length=13,
            ),
        ),
        migrations.AddField(
            model_name="question",
            name="answer_match_pattern",
            field=grandchallenge.core.fields.RegexField(
                blank=True,
                help_text="Regular expression to match a pattern for answers of type Text. Can only be set in combination with the 'Text Input' or 'Text Area' widgets.",
            ),
        ),
        migrations.AddField(
            model_name="question",
            name="answer_max_length",
            field=models.PositiveSmallIntegerField(
                blank=True,
                default=None,
                help_text="Maximum length for answers of type Text. Can only be set in combination with the 'Text Input' or 'Text Area' widgets.",
                null=True,
            ),
        ),
        migrations.AddField(
            model_name="question",
            name="answer_min_length",
            field=models.PositiveSmallIntegerField(
                blank=True,
                default=None,
                help_text="Minimum length for answers of type Text. Can only be set in combination with the 'Text Input' or 'Text Area' widgets.",
                null=True,
            ),
        ),
    ]
