# Generated by Django 3.1.1 on 2020-12-02 13:08

import uuid

import django.db.models.deletion
import django_extensions.db.fields
import simple_history.models
from django.conf import settings
from django.db import migrations, models

import grandchallenge.core.storage
import grandchallenge.core.validators


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("cases", "0001_initial"),
        ("auth", "0012_alter_user_first_name_max_length"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("workstation_configs", "0001_squashed_0008_auto_20201001_0758"),
        ("workstations", "0001_squashed_0011_auto_20201001_0758"),
    ]

    operations = [
        migrations.CreateModel(
            name="ReaderStudy",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True)),
                ("modified", models.DateTimeField(auto_now=True)),
                (
                    "title",
                    models.CharField(max_length=255, verbose_name="title"),
                ),
                (
                    "description",
                    models.TextField(
                        blank=True, null=True, verbose_name="description"
                    ),
                ),
                (
                    "slug",
                    django_extensions.db.fields.AutoSlugField(
                        blank=True,
                        editable=False,
                        populate_from="title",
                        verbose_name="slug",
                    ),
                ),
                (
                    "public",
                    models.BooleanField(
                        default=False,
                        help_text="Should this reader study be visible to all users on the overview page? This does not grant all users permission to read this study. Users will still need to be added to the study's readers group in order to do that.",
                    ),
                ),
                (
                    "logo",
                    models.ImageField(
                        storage=grandchallenge.core.storage.PublicS3Storage(),
                        upload_to=grandchallenge.core.storage.get_logo_path,
                    ),
                ),
                ("help_text_markdown", models.TextField(blank=True)),
                (
                    "hanging_list",
                    models.JSONField(
                        blank=True,
                        default=list,
                        validators=[
                            grandchallenge.core.validators.JSONValidator(
                                schema={
                                    "$schema": "http://json-schema.org/draft-06/schema#",
                                    "definitions": {},
                                    "items": {
                                        "$id": "#/items",
                                        "additionalProperties": False,
                                        "properties": {
                                            "main": {
                                                "$id": "#/items/properties/main",
                                                "default": "",
                                                "examples": ["im1.mhd"],
                                                "pattern": "^(.*)$",
                                                "title": "The Main Schema",
                                                "type": "string",
                                            },
                                            "main-overlay": {
                                                "$id": "#/items/properties/main-overlay",
                                                "default": "",
                                                "examples": [
                                                    "im1-overlay.mhd"
                                                ],
                                                "pattern": "^(.*)$",
                                                "title": "The Main Overlay Schema",
                                                "type": "string",
                                            },
                                            "secondary": {
                                                "$id": "#/items/properties/secondary",
                                                "default": "",
                                                "examples": ["im2.mhd"],
                                                "pattern": "^(.*)$",
                                                "title": "The Secondary Schema",
                                                "type": "string",
                                            },
                                            "secondary-overlay": {
                                                "$id": "#/items/properties/secondary-overlay",
                                                "default": "",
                                                "examples": [
                                                    "im2-overlay.mhd"
                                                ],
                                                "pattern": "^(.*)$",
                                                "title": "The Secondary Overlay Schema",
                                                "type": "string",
                                            },
                                        },
                                        "required": ["main"],
                                        "title": "The Items Schema",
                                        "type": "object",
                                    },
                                    "title": "The Hanging List Schema",
                                    "type": "array",
                                }
                            )
                        ],
                    ),
                ),
                ("shuffle_hanging_list", models.BooleanField(default=False)),
                (
                    "is_educational",
                    models.BooleanField(
                        default=False,
                        help_text="If checked, readers get the option to verify their answers against the uploaded ground truth. This also means that the uploaded ground truth will be readily available to the readers.",
                    ),
                ),
                (
                    "case_text",
                    models.JSONField(
                        blank=True,
                        default=dict,
                        validators=[
                            grandchallenge.core.validators.JSONValidator(
                                schema={
                                    "additionalProperties": {"type": "string"},
                                    "properties": {},
                                    "type": "object",
                                }
                            )
                        ],
                    ),
                ),
                (
                    "allow_answer_modification",
                    models.BooleanField(
                        default=False,
                        help_text="If true, readers are allowed to modify their answers for a case by navigating back to previous cases. 'allow_case_browsing' must be checked with this as well.",
                    ),
                ),
                (
                    "allow_case_navigation",
                    models.BooleanField(
                        default=False,
                        help_text="If true, readers are allowed to navigate back and forth between cases in this reader study.",
                    ),
                ),
                (
                    "allow_show_all_annotations",
                    models.BooleanField(
                        default=False,
                        help_text="If true, readers are allowed to show/hide all annotations for a case.",
                    ),
                ),
                ("validate_hanging_list", models.BooleanField(default=True)),
                (
                    "editors_group",
                    models.OneToOneField(
                        editable=False,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="editors_of_readerstudy",
                        to="auth.group",
                    ),
                ),
                (
                    "images",
                    models.ManyToManyField(
                        related_name="readerstudies", to="cases.Image"
                    ),
                ),
                (
                    "readers_group",
                    models.OneToOneField(
                        editable=False,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="readers_of_readerstudy",
                        to="auth.group",
                    ),
                ),
                (
                    "workstation",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="workstations.workstation",
                    ),
                ),
                (
                    "workstation_config",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="workstation_configs.workstationconfig",
                    ),
                ),
            ],
            options={
                "verbose_name_plural": "reader studies",
                "ordering": ("created",),
                "permissions": [("read_readerstudy", "Can read reader study")],
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="Question",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True)),
                ("modified", models.DateTimeField(auto_now=True)),
                ("question_text", models.TextField()),
                ("help_text", models.TextField(blank=True)),
                (
                    "answer_type",
                    models.CharField(
                        choices=[
                            ("STXT", "Single line text"),
                            ("MTXT", "Multi line text"),
                            ("BOOL", "Bool"),
                            ("HEAD", "Heading"),
                            ("2DBB", "2D bounding box"),
                            ("M2DB", "Multiple 2D bounding boxes"),
                            ("DIST", "Distance measurement"),
                            ("MDIS", "Multiple distance measurements"),
                            ("POIN", "Point"),
                            ("MPOI", "Multiple points"),
                            ("POLY", "Polygon"),
                            ("MPOL", "Multiple polygons"),
                            ("CHOI", "Choice"),
                            ("MCHO", "Multiple choice"),
                            ("MCHD", "Multiple choice dropdown"),
                        ],
                        default="STXT",
                        max_length=4,
                    ),
                ),
                (
                    "image_port",
                    models.CharField(
                        blank=True,
                        choices=[("M", "Main"), ("S", "Secondary")],
                        default="",
                        max_length=1,
                    ),
                ),
                ("required", models.BooleanField(default=True)),
                (
                    "direction",
                    models.CharField(
                        choices=[("H", "Horizontal"), ("V", "Vertical")],
                        default="H",
                        max_length=1,
                    ),
                ),
                (
                    "scoring_function",
                    models.CharField(
                        choices=[("ACC", "Accuracy score")],
                        default="ACC",
                        max_length=3,
                    ),
                ),
                ("order", models.PositiveSmallIntegerField(default=100)),
                (
                    "reader_study",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="questions",
                        to="reader_studies.readerstudy",
                    ),
                ),
            ],
            options={"ordering": ("order", "created")},
        ),
        migrations.CreateModel(
            name="HistoricalAnswer",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        db_index=True, default=uuid.uuid4, editable=False
                    ),
                ),
                (
                    "answer",
                    models.JSONField(
                        null=True,
                        validators=[
                            grandchallenge.core.validators.JSONValidator(
                                schema={
                                    "$schema": "http://json-schema.org/draft-07/schema#",
                                    "anyOf": [
                                        {"$ref": "#/definitions/null"},
                                        {"$ref": "#/definitions/STXT"},
                                        {"$ref": "#/definitions/MTXT"},
                                        {"$ref": "#/definitions/BOOL"},
                                        {"$ref": "#/definitions/HEAD"},
                                        {"$ref": "#/definitions/2DBB"},
                                        {"$ref": "#/definitions/DIST"},
                                        {"$ref": "#/definitions/MDIS"},
                                        {"$ref": "#/definitions/POIN"},
                                        {"$ref": "#/definitions/MPOI"},
                                        {"$ref": "#/definitions/POLY"},
                                        {"$ref": "#/definitions/MPOL"},
                                        {"$ref": "#/definitions/CHOI"},
                                        {"$ref": "#/definitions/MCHO"},
                                        {"$ref": "#/definitions/MCHD"},
                                        {"$ref": "#/definitions/M2DB"},
                                    ],
                                    "definitions": {
                                        "2D-bounding-box-object": {
                                            "properties": {
                                                "corners": {
                                                    "items": {
                                                        "items": {
                                                            "type": "number"
                                                        },
                                                        "maxItems": 3,
                                                        "minItems": 3,
                                                        "type": "array",
                                                    },
                                                    "maxItems": 4,
                                                    "minItems": 4,
                                                    "type": "array",
                                                },
                                                "name": {"type": "string"},
                                            },
                                            "required": ["corners"],
                                            "type": "object",
                                        },
                                        "2DBB": {
                                            "properties": {
                                                "corners": {
                                                    "items": {
                                                        "items": {
                                                            "type": "number"
                                                        },
                                                        "maxItems": 3,
                                                        "minItems": 3,
                                                        "type": "array",
                                                    },
                                                    "maxItems": 4,
                                                    "minItems": 4,
                                                    "type": "array",
                                                },
                                                "name": {"type": "string"},
                                                "type": {
                                                    "enum": ["2D bounding box"]
                                                },
                                            },
                                            "required": [
                                                "version",
                                                "type",
                                                "corners",
                                            ],
                                            "type": "object",
                                        },
                                        "BOOL": {"type": "boolean"},
                                        "CHOI": {"type": "number"},
                                        "DIST": {
                                            "properties": {
                                                "end": {
                                                    "items": {
                                                        "type": "number"
                                                    },
                                                    "maxItems": 3,
                                                    "minItems": 3,
                                                    "type": "array",
                                                },
                                                "name": {"type": "string"},
                                                "start": {
                                                    "items": {
                                                        "type": "number"
                                                    },
                                                    "maxItems": 3,
                                                    "minItems": 3,
                                                    "type": "array",
                                                },
                                                "type": {
                                                    "enum": [
                                                        "Distance measurement"
                                                    ]
                                                },
                                            },
                                            "required": [
                                                "version",
                                                "type",
                                                "start",
                                                "end",
                                            ],
                                            "type": "object",
                                        },
                                        "HEAD": {"type": "null"},
                                        "M2DB": {
                                            "properties": {
                                                "boxes": {
                                                    "items": {
                                                        "allOf": [
                                                            {
                                                                "$ref": "#/definitions/2D-bounding-box-object"
                                                            }
                                                        ]
                                                    },
                                                    "type": "array",
                                                },
                                                "name": {"type": "string"},
                                                "type": {
                                                    "enum": [
                                                        "Multiple 2D bounding boxes"
                                                    ]
                                                },
                                            },
                                            "required": [
                                                "version",
                                                "type",
                                                "boxes",
                                            ],
                                            "type": "object",
                                        },
                                        "MCHD": {
                                            "items": {"type": "number"},
                                            "type": "array",
                                        },
                                        "MCHO": {
                                            "items": {"type": "number"},
                                            "type": "array",
                                        },
                                        "MDIS": {
                                            "properties": {
                                                "lines": {
                                                    "items": {
                                                        "allOf": [
                                                            {
                                                                "$ref": "#/definitions/line-object"
                                                            }
                                                        ]
                                                    },
                                                    "type": "array",
                                                },
                                                "name": {"type": "string"},
                                                "type": {
                                                    "enum": [
                                                        "Multiple distance measurements"
                                                    ]
                                                },
                                            },
                                            "required": [
                                                "version",
                                                "type",
                                                "lines",
                                            ],
                                            "type": "object",
                                        },
                                        "MPOI": {
                                            "properties": {
                                                "name": {"type": "string"},
                                                "points": {
                                                    "items": {
                                                        "allOf": [
                                                            {
                                                                "$ref": "#/definitions/point-object"
                                                            }
                                                        ]
                                                    },
                                                    "type": "array",
                                                },
                                                "type": {
                                                    "enum": ["Multiple points"]
                                                },
                                            },
                                            "required": [
                                                "version",
                                                "type",
                                                "points",
                                            ],
                                            "type": "object",
                                        },
                                        "MPOL": {
                                            "properties": {
                                                "name": {"type": "string"},
                                                "polygons": {
                                                    "items": {
                                                        "$ref": "#/definitions/polygon-object"
                                                    },
                                                    "type": "array",
                                                },
                                                "type": {
                                                    "enum": [
                                                        "Multiple polygons"
                                                    ]
                                                },
                                            },
                                            "required": [
                                                "type",
                                                "version",
                                                "polygons",
                                            ],
                                            "type": "object",
                                        },
                                        "MTXT": {"type": "string"},
                                        "POIN": {
                                            "properties": {
                                                "name": {"type": "string"},
                                                "point": {
                                                    "items": {
                                                        "type": "number"
                                                    },
                                                    "maxItems": 3,
                                                    "minItems": 3,
                                                    "type": "array",
                                                },
                                                "type": {"enum": ["Point"]},
                                            },
                                            "required": [
                                                "version",
                                                "type",
                                                "point",
                                            ],
                                            "type": "object",
                                        },
                                        "POLY": {
                                            "properties": {
                                                "groups": {
                                                    "items": {
                                                        "type": "string"
                                                    },
                                                    "type": "array",
                                                },
                                                "name": {"type": "string"},
                                                "path_points": {
                                                    "items": {
                                                        "items": {
                                                            "type": "number"
                                                        },
                                                        "maxItems": 3,
                                                        "minItems": 3,
                                                        "type": "array",
                                                    },
                                                    "type": "array",
                                                },
                                                "seed_point": {
                                                    "items": {
                                                        "type": "number"
                                                    },
                                                    "maxItems": 3,
                                                    "minItems": 3,
                                                    "type": "array",
                                                },
                                                "sub_type": {"type": "string"},
                                            },
                                            "required": [
                                                "name",
                                                "seed_point",
                                                "path_points",
                                                "sub_type",
                                                "groups",
                                                "version",
                                            ],
                                            "type": "object",
                                        },
                                        "STXT": {"type": "string"},
                                        "line-object": {
                                            "properties": {
                                                "end": {
                                                    "items": {
                                                        "type": "number"
                                                    },
                                                    "maxItems": 3,
                                                    "minItems": 3,
                                                    "type": "array",
                                                },
                                                "name": {"type": "string"},
                                                "start": {
                                                    "items": {
                                                        "type": "number"
                                                    },
                                                    "maxItems": 3,
                                                    "minItems": 3,
                                                    "type": "array",
                                                },
                                            },
                                            "required": ["start", "end"],
                                            "type": "object",
                                        },
                                        "null": {"type": "null"},
                                        "point-object": {
                                            "properties": {
                                                "name": {"type": "string"},
                                                "point": {
                                                    "items": {
                                                        "type": "number"
                                                    },
                                                    "maxItems": 3,
                                                    "minItems": 3,
                                                    "type": "array",
                                                },
                                            },
                                            "required": ["point"],
                                            "type": "object",
                                        },
                                        "polygon-object": {
                                            "properties": {
                                                "groups": {
                                                    "items": {
                                                        "type": "string"
                                                    },
                                                    "type": "array",
                                                },
                                                "name": {"type": "string"},
                                                "path_points": {
                                                    "items": {
                                                        "items": {
                                                            "type": "number"
                                                        },
                                                        "maxItems": 3,
                                                        "minItems": 3,
                                                        "type": "array",
                                                    },
                                                    "type": "array",
                                                },
                                                "seed_point": {
                                                    "items": {
                                                        "type": "number"
                                                    },
                                                    "maxItems": 3,
                                                    "minItems": 3,
                                                    "type": "array",
                                                },
                                                "sub_type": {"type": "string"},
                                            },
                                            "required": [
                                                "name",
                                                "seed_point",
                                                "path_points",
                                                "sub_type",
                                                "groups",
                                            ],
                                            "type": "object",
                                        },
                                    },
                                    "properties": {
                                        "version": {
                                            "additionalProperties": {
                                                "type": "number"
                                            },
                                            "required": ["major", "minor"],
                                            "type": "object",
                                        }
                                    },
                                }
                            )
                        ],
                    ),
                ),
                ("explanation", models.TextField(blank=True, default="")),
                (
                    "history_id",
                    models.AutoField(primary_key=True, serialize=False),
                ),
                ("history_date", models.DateTimeField()),
                (
                    "history_change_reason",
                    models.CharField(max_length=100, null=True),
                ),
                (
                    "history_type",
                    models.CharField(
                        choices=[
                            ("+", "Created"),
                            ("~", "Changed"),
                            ("-", "Deleted"),
                        ],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "verbose_name": "historical answer",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="CategoricalOption",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("title", models.CharField(max_length=1024)),
                ("default", models.BooleanField(default=False)),
                (
                    "question",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="options",
                        to="reader_studies.question",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="Answer",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True)),
                ("modified", models.DateTimeField(auto_now=True)),
                (
                    "answer",
                    models.JSONField(
                        null=True,
                        validators=[
                            grandchallenge.core.validators.JSONValidator(
                                schema={
                                    "$schema": "http://json-schema.org/draft-07/schema#",
                                    "anyOf": [
                                        {"$ref": "#/definitions/null"},
                                        {"$ref": "#/definitions/STXT"},
                                        {"$ref": "#/definitions/MTXT"},
                                        {"$ref": "#/definitions/BOOL"},
                                        {"$ref": "#/definitions/HEAD"},
                                        {"$ref": "#/definitions/2DBB"},
                                        {"$ref": "#/definitions/DIST"},
                                        {"$ref": "#/definitions/MDIS"},
                                        {"$ref": "#/definitions/POIN"},
                                        {"$ref": "#/definitions/MPOI"},
                                        {"$ref": "#/definitions/POLY"},
                                        {"$ref": "#/definitions/MPOL"},
                                        {"$ref": "#/definitions/CHOI"},
                                        {"$ref": "#/definitions/MCHO"},
                                        {"$ref": "#/definitions/MCHD"},
                                        {"$ref": "#/definitions/M2DB"},
                                    ],
                                    "definitions": {
                                        "2D-bounding-box-object": {
                                            "properties": {
                                                "corners": {
                                                    "items": {
                                                        "items": {
                                                            "type": "number"
                                                        },
                                                        "maxItems": 3,
                                                        "minItems": 3,
                                                        "type": "array",
                                                    },
                                                    "maxItems": 4,
                                                    "minItems": 4,
                                                    "type": "array",
                                                },
                                                "name": {"type": "string"},
                                            },
                                            "required": ["corners"],
                                            "type": "object",
                                        },
                                        "2DBB": {
                                            "properties": {
                                                "corners": {
                                                    "items": {
                                                        "items": {
                                                            "type": "number"
                                                        },
                                                        "maxItems": 3,
                                                        "minItems": 3,
                                                        "type": "array",
                                                    },
                                                    "maxItems": 4,
                                                    "minItems": 4,
                                                    "type": "array",
                                                },
                                                "name": {"type": "string"},
                                                "type": {
                                                    "enum": ["2D bounding box"]
                                                },
                                            },
                                            "required": [
                                                "version",
                                                "type",
                                                "corners",
                                            ],
                                            "type": "object",
                                        },
                                        "BOOL": {"type": "boolean"},
                                        "CHOI": {"type": "number"},
                                        "DIST": {
                                            "properties": {
                                                "end": {
                                                    "items": {
                                                        "type": "number"
                                                    },
                                                    "maxItems": 3,
                                                    "minItems": 3,
                                                    "type": "array",
                                                },
                                                "name": {"type": "string"},
                                                "start": {
                                                    "items": {
                                                        "type": "number"
                                                    },
                                                    "maxItems": 3,
                                                    "minItems": 3,
                                                    "type": "array",
                                                },
                                                "type": {
                                                    "enum": [
                                                        "Distance measurement"
                                                    ]
                                                },
                                            },
                                            "required": [
                                                "version",
                                                "type",
                                                "start",
                                                "end",
                                            ],
                                            "type": "object",
                                        },
                                        "HEAD": {"type": "null"},
                                        "M2DB": {
                                            "properties": {
                                                "boxes": {
                                                    "items": {
                                                        "allOf": [
                                                            {
                                                                "$ref": "#/definitions/2D-bounding-box-object"
                                                            }
                                                        ]
                                                    },
                                                    "type": "array",
                                                },
                                                "name": {"type": "string"},
                                                "type": {
                                                    "enum": [
                                                        "Multiple 2D bounding boxes"
                                                    ]
                                                },
                                            },
                                            "required": [
                                                "version",
                                                "type",
                                                "boxes",
                                            ],
                                            "type": "object",
                                        },
                                        "MCHD": {
                                            "items": {"type": "number"},
                                            "type": "array",
                                        },
                                        "MCHO": {
                                            "items": {"type": "number"},
                                            "type": "array",
                                        },
                                        "MDIS": {
                                            "properties": {
                                                "lines": {
                                                    "items": {
                                                        "allOf": [
                                                            {
                                                                "$ref": "#/definitions/line-object"
                                                            }
                                                        ]
                                                    },
                                                    "type": "array",
                                                },
                                                "name": {"type": "string"},
                                                "type": {
                                                    "enum": [
                                                        "Multiple distance measurements"
                                                    ]
                                                },
                                            },
                                            "required": [
                                                "version",
                                                "type",
                                                "lines",
                                            ],
                                            "type": "object",
                                        },
                                        "MPOI": {
                                            "properties": {
                                                "name": {"type": "string"},
                                                "points": {
                                                    "items": {
                                                        "allOf": [
                                                            {
                                                                "$ref": "#/definitions/point-object"
                                                            }
                                                        ]
                                                    },
                                                    "type": "array",
                                                },
                                                "type": {
                                                    "enum": ["Multiple points"]
                                                },
                                            },
                                            "required": [
                                                "version",
                                                "type",
                                                "points",
                                            ],
                                            "type": "object",
                                        },
                                        "MPOL": {
                                            "properties": {
                                                "name": {"type": "string"},
                                                "polygons": {
                                                    "items": {
                                                        "$ref": "#/definitions/polygon-object"
                                                    },
                                                    "type": "array",
                                                },
                                                "type": {
                                                    "enum": [
                                                        "Multiple polygons"
                                                    ]
                                                },
                                            },
                                            "required": [
                                                "type",
                                                "version",
                                                "polygons",
                                            ],
                                            "type": "object",
                                        },
                                        "MTXT": {"type": "string"},
                                        "POIN": {
                                            "properties": {
                                                "name": {"type": "string"},
                                                "point": {
                                                    "items": {
                                                        "type": "number"
                                                    },
                                                    "maxItems": 3,
                                                    "minItems": 3,
                                                    "type": "array",
                                                },
                                                "type": {"enum": ["Point"]},
                                            },
                                            "required": [
                                                "version",
                                                "type",
                                                "point",
                                            ],
                                            "type": "object",
                                        },
                                        "POLY": {
                                            "properties": {
                                                "groups": {
                                                    "items": {
                                                        "type": "string"
                                                    },
                                                    "type": "array",
                                                },
                                                "name": {"type": "string"},
                                                "path_points": {
                                                    "items": {
                                                        "items": {
                                                            "type": "number"
                                                        },
                                                        "maxItems": 3,
                                                        "minItems": 3,
                                                        "type": "array",
                                                    },
                                                    "type": "array",
                                                },
                                                "seed_point": {
                                                    "items": {
                                                        "type": "number"
                                                    },
                                                    "maxItems": 3,
                                                    "minItems": 3,
                                                    "type": "array",
                                                },
                                                "sub_type": {"type": "string"},
                                            },
                                            "required": [
                                                "name",
                                                "seed_point",
                                                "path_points",
                                                "sub_type",
                                                "groups",
                                                "version",
                                            ],
                                            "type": "object",
                                        },
                                        "STXT": {"type": "string"},
                                        "line-object": {
                                            "properties": {
                                                "end": {
                                                    "items": {
                                                        "type": "number"
                                                    },
                                                    "maxItems": 3,
                                                    "minItems": 3,
                                                    "type": "array",
                                                },
                                                "name": {"type": "string"},
                                                "start": {
                                                    "items": {
                                                        "type": "number"
                                                    },
                                                    "maxItems": 3,
                                                    "minItems": 3,
                                                    "type": "array",
                                                },
                                            },
                                            "required": ["start", "end"],
                                            "type": "object",
                                        },
                                        "null": {"type": "null"},
                                        "point-object": {
                                            "properties": {
                                                "name": {"type": "string"},
                                                "point": {
                                                    "items": {
                                                        "type": "number"
                                                    },
                                                    "maxItems": 3,
                                                    "minItems": 3,
                                                    "type": "array",
                                                },
                                            },
                                            "required": ["point"],
                                            "type": "object",
                                        },
                                        "polygon-object": {
                                            "properties": {
                                                "groups": {
                                                    "items": {
                                                        "type": "string"
                                                    },
                                                    "type": "array",
                                                },
                                                "name": {"type": "string"},
                                                "path_points": {
                                                    "items": {
                                                        "items": {
                                                            "type": "number"
                                                        },
                                                        "maxItems": 3,
                                                        "minItems": 3,
                                                        "type": "array",
                                                    },
                                                    "type": "array",
                                                },
                                                "seed_point": {
                                                    "items": {
                                                        "type": "number"
                                                    },
                                                    "maxItems": 3,
                                                    "minItems": 3,
                                                    "type": "array",
                                                },
                                                "sub_type": {"type": "string"},
                                            },
                                            "required": [
                                                "name",
                                                "seed_point",
                                                "path_points",
                                                "sub_type",
                                                "groups",
                                            ],
                                            "type": "object",
                                        },
                                    },
                                    "properties": {
                                        "version": {
                                            "additionalProperties": {
                                                "type": "number"
                                            },
                                            "required": ["major", "minor"],
                                            "type": "object",
                                        }
                                    },
                                }
                            )
                        ],
                    ),
                ),
                ("is_ground_truth", models.BooleanField(default=False)),
                ("score", models.FloatField(null=True)),
                ("explanation", models.TextField(blank=True, default="")),
                (
                    "creator",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "images",
                    models.ManyToManyField(
                        related_name="answers", to="cases.Image"
                    ),
                ),
                (
                    "question",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="reader_studies.question",
                    ),
                ),
            ],
            options={"ordering": ("creator", "created")},
        ),
        migrations.CreateModel(
            name="ReaderStudyPermissionRequest",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True)),
                ("changed", models.DateTimeField(auto_now=True)),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("PEND", "Pending"),
                            ("ACPT", "Accepted"),
                            ("RJCT", "Rejected"),
                        ],
                        default="PEND",
                        max_length=4,
                    ),
                ),
                (
                    "rejection_text",
                    models.TextField(
                        blank=True,
                        help_text="The text that will be sent to the user with the reason for their rejection.",
                    ),
                ),
                (
                    "reader_study",
                    models.ForeignKey(
                        help_text="To which reader study has the user requested access?",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="reader_studies.readerstudy",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        help_text="which user requested to participate?",
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "abstract": False,
                "unique_together": {("reader_study", "user")},
            },
        ),
    ]
