# Generated by Django 3.0.2 on 2020-02-13 10:42

import django.db.models.deletion
from django.db import migrations, models

import grandchallenge.core.storage


class Migration(migrations.Migration):

    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="Company",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True)),
                ("modified", models.DateTimeField(auto_now=True)),
                ("company_name", models.CharField(max_length=200)),
                ("website", models.URLField()),
                ("founded", models.IntegerField()),
                ("hq", models.CharField(max_length=100)),
                ("email", models.EmailField(max_length=254)),
                (
                    "logo",
                    models.ImageField(
                        null=True,
                        upload_to=grandchallenge.core.storage.get_logo_path,
                    ),
                ),
                (
                    "description",
                    models.TextField(
                        blank=True, help_text="Short summary of this project."
                    ),
                ),
                (
                    "description_short",
                    models.CharField(
                        blank=True,
                        help_text="Short summary of this project, max 250 characters.",
                        max_length=250,
                    ),
                ),
            ],
            options={"verbose_name_plural": "companies"},
        ),
        migrations.CreateModel(
            name="ProductImage",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "img",
                    models.ImageField(
                        upload_to=grandchallenge.core.storage.get_logo_path
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="Product",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True)),
                ("modified", models.DateTimeField(auto_now=True)),
                ("product_name", models.CharField(max_length=200)),
                (
                    "short_name",
                    models.CharField(
                        help_text="short name used in url, specific css, files etc. No spaces allowed",
                        max_length=500,
                        unique=True,
                    ),
                ),
                (
                    "description",
                    models.TextField(
                        blank=True, help_text="Short summary of this project."
                    ),
                ),
                (
                    "description_short",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text="Short summary of this project, max 250 characters.",
                        max_length=250,
                    ),
                ),
                ("modality", models.CharField(max_length=100)),
                ("subspeciality", models.CharField(max_length=300)),
                ("diseases", models.CharField(max_length=200)),
                ("population", models.CharField(max_length=200)),
                ("input_data", models.CharField(max_length=150)),
                ("file_format_input", models.TextField()),
                ("output_data", models.CharField(max_length=150)),
                ("file_format_output", models.TextField()),
                ("key_features", models.CharField(max_length=200)),
                ("key_features_short", models.CharField(max_length=120)),
                ("software_usage", models.TextField()),
                (
                    "verified",
                    models.CharField(
                        choices=[("yes", "Yes"), ("no", "No")],
                        default="no",
                        max_length=3,
                    ),
                ),
                (
                    "ce_status",
                    models.CharField(
                        choices=[
                            ("cer", "Certified"),
                            ("no", "No or not yet"),
                            ("na", "Not applicable"),
                            ("unk", "Unknown"),
                        ],
                        default="no",
                        max_length=3,
                    ),
                ),
                (
                    "ce_class",
                    models.CharField(default="unknown", max_length=500),
                ),
                (
                    "fda_status",
                    models.CharField(
                        choices=[
                            ("cle", "510(k) cleared"),
                            ("dnc", "De novo 510(k) cleared"),
                            ("pma", "PMA approved"),
                            ("unk", "No or not yet"),
                            ("no", "Not applicable"),
                            ("na", "Unknown"),
                        ],
                        default="na",
                        max_length=3,
                    ),
                ),
                (
                    "fda_class",
                    models.CharField(default="unknown", max_length=500),
                ),
                (
                    "ce_verified",
                    models.CharField(
                        choices=[("yes", "Yes"), ("no", "No")],
                        default="no",
                        max_length=3,
                    ),
                ),
                ("integration", models.TextField()),
                ("deployment", models.TextField()),
                ("process_time", models.TextField()),
                ("trigger", models.CharField(max_length=100)),
                ("market_since", models.TextField()),
                ("countries", models.TextField()),
                ("distribution", models.CharField(blank=True, max_length=100)),
                ("institutes_research", models.TextField()),
                ("institutes_clinic", models.TextField()),
                ("pricing_model", models.TextField()),
                ("pricing_basis", models.TextField()),
                ("tech_papers", models.TextField()),
                ("clin_papers", models.TextField()),
                ("tech_peer_papers", models.TextField()),
                ("tech_other_papers", models.TextField()),
                ("all_other_papers", models.TextField()),
                (
                    "company",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="products.Company",
                    ),
                ),
                ("images", models.ManyToManyField(to="products.ProductImage")),
            ],
        ),
    ]
