# Generated by Django 3.1.11 on 2021-06-01 10:00

import django.db.models.deletion
import simple_history.models
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ("challenges", "0006_auto_20210601_0802"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("pages", "0002_auto_20210601_0802"),
    ]

    operations = [
        migrations.CreateModel(
            name="HistoricalPage",
            fields=[
                (
                    "id",
                    models.IntegerField(
                        auto_created=True,
                        blank=True,
                        db_index=True,
                        verbose_name="ID",
                    ),
                ),
                ("title", models.SlugField(max_length=64)),
                (
                    "permission_level",
                    models.CharField(
                        choices=[
                            ("ALL", "All"),
                            ("REG", "Participants only"),
                            ("ADM", "Administrators only"),
                        ],
                        default="ALL",
                        max_length=3,
                    ),
                ),
                (
                    "order",
                    models.IntegerField(
                        default=1,
                        editable=False,
                        help_text="Determines order in which page appear in site menu",
                    ),
                ),
                (
                    "display_title",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text="On pages and in menu items, use this text. Spaces and special chars allowed here. Optional field. If emtpy, title is used",
                        max_length=255,
                    ),
                ),
                (
                    "hidden",
                    models.BooleanField(
                        default=False,
                        help_text="Do not display this page in site menu",
                    ),
                ),
                ("html", models.TextField(blank=True, default="")),
                (
                    "history_id",
                    models.AutoField(primary_key=True, serialize=False),
                ),
                ("history_date", models.DateTimeField()),
                (
                    "history_change_reason",
                    models.CharField(max_length=100, null=True),
                ),
                (
                    "history_type",
                    models.CharField(
                        choices=[
                            ("+", "Created"),
                            ("~", "Changed"),
                            ("-", "Deleted"),
                        ],
                        max_length=1,
                    ),
                ),
                (
                    "challenge",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        help_text="Which challenge does this page belong to?",
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="challenges.challenge",
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "verbose_name": "historical page",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        )
    ]
