# Generated by Django 3.1.1 on 2020-12-15 13:16

import uuid

import django.db.models.deletion
import django_countries.fields
import django_extensions.db.fields
from django.db import migrations, models

import grandchallenge.core.storage


class Migration(migrations.Migration):
    initial = True

    dependencies = [("auth", "0012_alter_user_first_name_max_length")]

    operations = [
        migrations.CreateModel(
            name="Organization",
            fields=[
                (
                    "title",
                    models.CharField(max_length=255, verbose_name="title"),
                ),
                (
                    "slug",
                    django_extensions.db.fields.AutoSlugField(
                        blank=True,
                        editable=False,
                        populate_from="title",
                        verbose_name="slug",
                    ),
                ),
                (
                    "description",
                    models.TextField(blank=True, verbose_name="description"),
                ),
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True)),
                ("modified", models.DateTimeField(auto_now=True)),
                (
                    "logo",
                    models.ImageField(
                        storage=grandchallenge.core.storage.PublicS3Storage(),
                        upload_to=grandchallenge.core.storage.get_logo_path,
                    ),
                ),
                (
                    "location",
                    django_countries.fields.CountryField(max_length=2),
                ),
                ("website", models.URLField()),
                ("detail_page_markdown", models.TextField(blank=True)),
                (
                    "editors_group",
                    models.OneToOneField(
                        editable=False,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="editors_of_organization",
                        to="auth.group",
                    ),
                ),
                (
                    "members_group",
                    models.OneToOneField(
                        editable=False,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="members_of_organization",
                        to="auth.group",
                    ),
                ),
            ],
            options={"ordering": ("created",), "abstract": False},
        )
    ]
