# Generated by Django 3.1.13 on 2021-09-06 08:55
import django.db.models.deletion
from django.db import migrations, models
from django_add_default_value import AddDefaultValue


class Migration(migrations.Migration):

    dependencies = [
        ("contenttypes", "0002_remove_content_type_name"),
        ("actstream", "0003_add_follow_flag"),
        ("notifications", "0001_initial"),
    ]

    operations = [
        migrations.AddField(
            model_name="notification",
            name="action_object_content_type",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="notification_action_object",
                to="contenttypes.contenttype",
            ),
        ),
        migrations.AddField(
            model_name="notification",
            name="action_object_object_id",
            field=models.CharField(
                blank=True, db_index=True, max_length=255, null=True
            ),
        ),
        migrations.AddField(
            model_name="notification",
            name="actor_content_type",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="notification_actor",
                to="contenttypes.contenttype",
            ),
        ),
        migrations.AddField(
            model_name="notification",
            name="actor_object_id",
            field=models.CharField(
                blank=True, db_index=True, max_length=255, null=True
            ),
        ),
        migrations.AddField(
            model_name="notification",
            name="context_class",
            field=models.CharField(
                blank=True,
                help_text="Bootstrap contextual class to style notification list items.",
                max_length=10,
                null=True,
            ),
        ),
        migrations.AddField(
            model_name="notification",
            name="description",
            field=models.TextField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name="notification",
            name="message",
            field=models.CharField(
                blank=True, db_index=True, max_length=255, null=True
            ),
        ),
        migrations.AddField(
            model_name="notification",
            name="target_content_type",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="notification_target",
                to="contenttypes.contenttype",
            ),
        ),
        migrations.AddField(
            model_name="notification",
            name="target_object_id",
            field=models.CharField(
                blank=True, db_index=True, max_length=255, null=True
            ),
        ),
        migrations.AddField(
            model_name="notification",
            name="type",
            field=models.CharField(
                choices=[
                    ("GENERIC", "Generic"),
                    ("FORUM-POST", "Forum post"),
                    ("FORUM-REPLY", "Forum post reply"),
                    ("ACCESS-REQUEST", "Access request"),
                    ("REQUEST-UPDATE", "Request update"),
                    ("NEW-ADMIN", "New admin"),
                    ("EVALUATION-STATUS", "Evaluation status update"),
                    ("MISSING-METHOD", "Missing method"),
                    ("JOB-STATUS", "Job status update"),
                    ("IMAGE-IMPORT", "Image import status update"),
                ],
                default="GENERIC",
                help_text="Of what type is this notification?",
                max_length=20,
            ),
        ),
        AddDefaultValue(
            model_name="notification", name="type", value="GENERIC"
        ),
        migrations.AlterField(
            model_name="notification",
            name="action",
            field=models.ForeignKey(
                blank=True,
                help_text="Which action is associated with this notification?",
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to="actstream.action",
            ),
        ),
    ]
