# Generated by Django 4.1.11 on 2023-09-28 14:48

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("challenges", "0030_challenge_compute_cost_euro_millicents_and_more"),
    ]

    operations = [
        migrations.CreateModel(
            name="Invoice",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True)),
                ("updated", models.DateTimeField(auto_now=True)),
                (
                    "issued_on",
                    models.DateField(
                        blank=True,
                        help_text="The date when the invoice was issued",
                        null=True,
                    ),
                ),
                (
                    "paid_on",
                    models.DateField(
                        blank=True,
                        help_text="The date when the invoice was paid",
                        null=True,
                    ),
                ),
                (
                    "last_checked_on",
                    models.DateField(
                        blank=True,
                        help_text="The date when the invoice status was last checked",
                        null=True,
                    ),
                ),
                (
                    "support_costs_euros",
                    models.PositiveIntegerField(
                        help_text="The support contribution in Euros"
                    ),
                ),
                (
                    "compute_costs_euros",
                    models.PositiveIntegerField(
                        help_text="The capacity reservation in Euros"
                    ),
                ),
                (
                    "storage_costs_euros",
                    models.PositiveIntegerField(
                        help_text="The storage costs in Euros"
                    ),
                ),
                (
                    "internal_invoice_number",
                    models.CharField(
                        blank=True,
                        help_text="The internal invoice number",
                        max_length=16,
                    ),
                ),
                (
                    "internal_client_number",
                    models.CharField(
                        blank=True,
                        help_text="The internal client number",
                        max_length=8,
                    ),
                ),
                (
                    "internal_comments",
                    models.TextField(
                        blank=True,
                        help_text="Internal comments about the invoice",
                    ),
                ),
                (
                    "contact_name",
                    models.CharField(
                        blank=True,
                        help_text="Name of the person the invoice should be sent to",
                        max_length=32,
                    ),
                ),
                (
                    "contact_email",
                    models.EmailField(
                        blank=True,
                        help_text="Email of the person the invoice should be sent to",
                        max_length=254,
                    ),
                ),
                (
                    "billing_address",
                    models.TextField(
                        blank=True,
                        help_text="The physical address of the client",
                    ),
                ),
                (
                    "vat_number",
                    models.CharField(
                        blank=True,
                        help_text="The VAT number of the client",
                        max_length=32,
                    ),
                ),
                (
                    "external_reference",
                    models.TextField(
                        blank=True,
                        help_text="Optional reference to be included with the invoice for the client",
                    ),
                ),
                (
                    "payment_status",
                    models.CharField(
                        choices=[
                            ("INITIALIZED", "Initialized"),
                            ("ISSUED", "Issued"),
                            ("COMPLIMENTARY", "Complimentary"),
                            ("PAID", "Paid"),
                        ],
                        default="INITIALIZED",
                        max_length=13,
                    ),
                ),
                (
                    "challenge",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="invoices",
                        to="challenges.challenge",
                    ),
                ),
            ],
        ),
    ]
