# Generated by Django 3.2.12 on 2022-03-16 14:37

import uuid

import django.db.models.deletion
import django_extensions.db.fields
from django.conf import settings
from django.db import migrations, models

import grandchallenge.core.validators


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="HangingProtocol",
            fields=[
                (
                    "title",
                    models.CharField(max_length=255, verbose_name="title"),
                ),
                (
                    "slug",
                    django_extensions.db.fields.AutoSlugField(
                        blank=True,
                        editable=False,
                        populate_from="title",
                        verbose_name="slug",
                    ),
                ),
                (
                    "description",
                    models.TextField(blank=True, verbose_name="description"),
                ),
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True)),
                ("modified", models.DateTimeField(auto_now=True)),
                (
                    "json",
                    models.JSONField(
                        validators=[
                            grandchallenge.core.validators.JSONValidator(
                                schema={
                                    "$schema": "http://json-schema.org/draft-06/schema#",
                                    "contains": {
                                        "properties": {
                                            "viewport_name": {
                                                "pattern": "^main$",
                                                "type": "string",
                                            }
                                        },
                                        "type": "object",
                                    },
                                    "definitions": {},
                                    "items": {
                                        "properties": {
                                            "draggable": {"type": "boolean"},
                                            "fullsizable": {"type": "boolean"},
                                            "h": {"type": "integer"},
                                            "order": {"type": "integer"},
                                            "selectable": {"type": "boolean"},
                                            "viewport_name": {
                                                "enum": [
                                                    "main",
                                                    "secondary",
                                                    "tertiary",
                                                    "quaternary",
                                                    "quinary",
                                                    "senary",
                                                    "septenary",
                                                    "octonary",
                                                    "nonary",
                                                    "denary",
                                                ],
                                                "type": "string",
                                            },
                                            "w": {"type": "integer"},
                                            "x": {"type": "integer"},
                                            "y": {"type": "integer"},
                                        },
                                        "required": ["viewport_name"],
                                        "title": "The Layout Object Schema",
                                        "type": "object",
                                    },
                                    "minItems": 1,
                                    "title": "The Hanging Protocol Schema",
                                    "type": "array",
                                    "uniqueItems": True,
                                }
                            )
                        ]
                    ),
                ),
                (
                    "creator",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "ordering": ("title",),
                "abstract": False,
            },
        ),
    ]
