# Generated by Django 4.1.10 on 2023-07-20 12:46

import uuid

import django.db.models.deletion
import django_extensions.db.fields
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        (
            "challenges",
            "0029_alter_challenge_educational_alter_challenge_hidden",
        ),
        ("evaluation", "0039_alter_phase_title"),
    ]

    operations = [
        migrations.CreateModel(
            name="CombinedLeaderboard",
            fields=[
                (
                    "title",
                    models.CharField(max_length=255, verbose_name="title"),
                ),
                (
                    "slug",
                    django_extensions.db.fields.AutoSlugField(
                        blank=True,
                        editable=False,
                        populate_from="title",
                        verbose_name="slug",
                    ),
                ),
                (
                    "description",
                    models.TextField(blank=True, verbose_name="description"),
                ),
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True)),
                ("modified", models.DateTimeField(auto_now=True)),
                (
                    "combination_method",
                    models.CharField(
                        choices=[
                            ("MEAN", "Mean"),
                            ("MEDIAN", "Median"),
                            ("SUM", "Sum"),
                        ],
                        default="MEAN",
                        max_length=6,
                    ),
                ),
                (
                    "challenge",
                    models.ForeignKey(
                        editable=False,
                        on_delete=django.db.models.deletion.PROTECT,
                        to="challenges.challenge",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="CombinedLeaderboardPhase",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "combined_leaderboard",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="evaluation.combinedleaderboard",
                    ),
                ),
                (
                    "phase",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="evaluation.phase",
                    ),
                ),
            ],
        ),
        migrations.AddField(
            model_name="combinedleaderboard",
            name="phases",
            field=models.ManyToManyField(
                through="evaluation.CombinedLeaderboardPhase",
                to="evaluation.phase",
            ),
        ),
        migrations.AlterUniqueTogether(
            name="combinedleaderboard",
            unique_together={("challenge", "slug")},
        ),
    ]
