# Generated by Django 4.1.9 on 2023-06-28 07:35

from django.db import migrations, models

import grandchallenge.core.validators


class Migration(migrations.Migration):
    dependencies = [
        ("evaluation", "0037_remove_method_ready"),
    ]

    operations = [
        migrations.AlterField(
            model_name="phase",
            name="extra_results_columns",
            field=models.JSONField(
                blank=True,
                default=list,
                help_text='A JSON object that contains the extra columns from metrics.json that will be displayed on the results page. An example that will display accuracy score with error would look like this: [{"path": "accuracy.mean","order": "asc","title": "ASSD +/- std","error_path": "accuracy.std"}]',
                validators=[
                    grandchallenge.core.validators.JSONValidator(
                        schema={
                            "$schema": "http://json-schema.org/draft-06/schema#",
                            "definitions": {},
                            "items": {
                                "$id": "#/items",
                                "additionalProperties": False,
                                "properties": {
                                    "error_path": {
                                        "$id": "#/items/properties/error_path",
                                        "default": "",
                                        "examples": ["aggregates.dice.std"],
                                        "pattern": "^(.*)$",
                                        "title": "The Error Path Schema",
                                        "type": "string",
                                    },
                                    "order": {
                                        "$id": "#/items/properties/order",
                                        "default": "",
                                        "enum": ["asc", "desc"],
                                        "examples": ["asc"],
                                        "pattern": "^(asc|desc)$",
                                        "title": "The Order Schema",
                                        "type": "string",
                                    },
                                    "path": {
                                        "$id": "#/items/properties/path",
                                        "default": "",
                                        "examples": ["aggregates.dice.mean"],
                                        "pattern": "^(.*)$",
                                        "title": "The Path Schema",
                                        "type": "string",
                                    },
                                    "title": {
                                        "$id": "#/items/properties/title",
                                        "default": "",
                                        "examples": ["Mean Dice"],
                                        "pattern": "^(.*)$",
                                        "title": "The Title Schema",
                                        "type": "string",
                                    },
                                },
                                "required": ["title", "path", "order"],
                                "title": "The Items Schema",
                                "type": "object",
                            },
                            "title": "The Extra Results Columns Schema",
                            "type": "array",
                        }
                    )
                ],
            ),
        ),
    ]
