# Generated by Django 3.1.1 on 2020-12-02 13:26

import uuid
from decimal import Decimal

import django.core.validators
import django.db.models.deletion
import django_extensions.db.fields
from django.conf import settings
from django.db import migrations, models

import grandchallenge.components.models
import grandchallenge.core.storage
import grandchallenge.core.validators
import grandchallenge.evaluation.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("algorithms", "0001_initial"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("challenges", "0001_initial"),
        ("components", "0001_initial"),
        ("archives", "0001_initial"),
    ]

    operations = [
        migrations.CreateModel(
            name="Phase",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True)),
                ("modified", models.DateTimeField(auto_now=True)),
                (
                    "title",
                    models.CharField(
                        default="Challenge",
                        help_text="The title of this phase.",
                        max_length=64,
                    ),
                ),
                (
                    "slug",
                    django_extensions.db.fields.AutoSlugField(
                        blank=True,
                        editable=False,
                        max_length=64,
                        populate_from="title",
                    ),
                ),
                (
                    "score_title",
                    models.CharField(
                        default="Score",
                        help_text="The name that will be displayed for the scores column, for instance: Score (log-loss)",
                        max_length=32,
                    ),
                ),
                (
                    "score_jsonpath",
                    models.CharField(
                        blank=True,
                        help_text="The jsonpath of the field in metrics.json that will be used for the overall scores on the results page. See http://goessner.net/articles/JsonPath/ for syntax. For example: dice.mean",
                        max_length=255,
                    ),
                ),
                (
                    "score_error_jsonpath",
                    models.CharField(
                        blank=True,
                        help_text="The jsonpath for the field in metrics.json that contains the error of the score, eg: dice.std",
                        max_length=255,
                    ),
                ),
                (
                    "score_default_sort",
                    models.CharField(
                        choices=[("asc", "Ascending"), ("desc", "Descending")],
                        default="desc",
                        help_text="The default sorting to use for the scores on the results page.",
                        max_length=4,
                    ),
                ),
                (
                    "score_decimal_places",
                    models.PositiveSmallIntegerField(
                        default=4,
                        help_text="The number of decimal places to display for the score",
                    ),
                ),
                (
                    "extra_results_columns",
                    models.JSONField(
                        blank=True,
                        default=list,
                        help_text="A JSON object that contains the extra columns from metrics.json that will be displayed on the results page. ",
                        validators=[
                            grandchallenge.core.validators.JSONValidator(
                                schema={
                                    "$schema": "http://json-schema.org/draft-06/schema#",
                                    "definitions": {},
                                    "items": {
                                        "$id": "#/items",
                                        "additionalProperties": False,
                                        "properties": {
                                            "error_path": {
                                                "$id": "#/items/properties/error_path",
                                                "default": "",
                                                "examples": [
                                                    "aggregates.dice.std"
                                                ],
                                                "pattern": "^(.*)$",
                                                "title": "The Error Path Schema",
                                                "type": "string",
                                            },
                                            "order": {
                                                "$id": "#/items/properties/order",
                                                "default": "",
                                                "enum": ["asc", "desc"],
                                                "examples": ["asc"],
                                                "pattern": "^(asc|desc)$",
                                                "title": "The Order Schema",
                                                "type": "string",
                                            },
                                            "path": {
                                                "$id": "#/items/properties/path",
                                                "default": "",
                                                "examples": [
                                                    "aggregates.dice.mean"
                                                ],
                                                "pattern": "^(.*)$",
                                                "title": "The Path Schema",
                                                "type": "string",
                                            },
                                            "title": {
                                                "$id": "#/items/properties/title",
                                                "default": "",
                                                "examples": ["Mean Dice"],
                                                "pattern": "^(.*)$",
                                                "title": "The Title Schema",
                                                "type": "string",
                                            },
                                        },
                                        "required": ["title", "path", "order"],
                                        "title": "The Items Schema",
                                        "type": "object",
                                    },
                                    "title": "The Extra Results Columns Schema",
                                    "type": "array",
                                }
                            )
                        ],
                    ),
                ),
                (
                    "scoring_method_choice",
                    models.CharField(
                        choices=[
                            (
                                "abs",
                                "Use the absolute value of the score column",
                            ),
                            (
                                "avg",
                                "Use the mean of the relative ranks of the score and extra result columns",
                            ),
                            (
                                "med",
                                "Use the median of the relative ranks of the score and extra result columns",
                            ),
                        ],
                        default="abs",
                        help_text="How should the rank of each result be calculated?",
                        max_length=3,
                    ),
                ),
                (
                    "result_display_choice",
                    models.CharField(
                        choices=[
                            ("all", "Display all results"),
                            (
                                "rec",
                                "Only display each users most recent result",
                            ),
                            ("bst", "Only display each users best result"),
                        ],
                        default="all",
                        help_text="Which results should be displayed on the leaderboard?",
                        max_length=3,
                    ),
                ),
                (
                    "submission_kind",
                    models.PositiveSmallIntegerField(
                        choices=[(1, "CSV"), (2, "ZIP"), (3, "Algorithm")],
                        default=1,
                        help_text="Should participants submit a .csv/.zip file of predictions, or an algorithm?",
                    ),
                ),
                (
                    "allow_submission_comments",
                    models.BooleanField(
                        default=False,
                        help_text="Allow users to submit comments as part of their submission.",
                    ),
                ),
                (
                    "display_submission_comments",
                    models.BooleanField(
                        default=False,
                        help_text="If true, submission comments are shown on the results page.",
                    ),
                ),
                (
                    "supplementary_file_choice",
                    models.CharField(
                        choices=[
                            ("off", "Off"),
                            ("opt", "Optional"),
                            ("req", "Required"),
                        ],
                        default="off",
                        help_text="Show a supplementary file field on the submissions page so that users can upload an additional file along with their predictions file as part of their submission (eg, include a pdf description of their method). Off turns this feature off, Optional means that including the file is optional for the user, Required means that the user must upload a supplementary file.",
                        max_length=3,
                    ),
                ),
                (
                    "supplementary_file_label",
                    models.CharField(
                        blank=True,
                        default="Supplementary File",
                        help_text="The label that will be used on the submission and results page for the supplementary file. For example: Algorithm Description.",
                        max_length=32,
                    ),
                ),
                (
                    "supplementary_file_help_text",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text='The help text to include on the submissions page to describe the submissions file. Eg: "A PDF description of the method.".',
                        max_length=128,
                    ),
                ),
                (
                    "show_supplementary_file_link",
                    models.BooleanField(
                        default=False,
                        help_text="Show a link to download the supplementary file on the results page.",
                    ),
                ),
                (
                    "publication_url_choice",
                    models.CharField(
                        choices=[
                            ("off", "Off"),
                            ("opt", "Optional"),
                            ("req", "Required"),
                        ],
                        default="off",
                        help_text="Show a supplementary url field on the submission page so that users can submit a link to a publication that corresponds to their submission. Off turns this feature off, Optional means that including the url is optional for the user, Required means that the user must provide an url.",
                        max_length=3,
                    ),
                ),
                (
                    "show_publication_url",
                    models.BooleanField(
                        default=False,
                        help_text="Show a link to the supplementary url on the results page",
                    ),
                ),
                (
                    "daily_submission_limit",
                    models.PositiveIntegerField(
                        default=10,
                        help_text="The limit on the number of times that a user can make a submission over the submission limit period. Set this to 0 to close submissions for this phase.",
                    ),
                ),
                (
                    "submissions_open",
                    models.DateTimeField(
                        blank=True,
                        help_text="If set, participants will not be able to make submissions to this phase before this time.",
                        null=True,
                    ),
                ),
                (
                    "submissions_close",
                    models.DateTimeField(
                        blank=True,
                        help_text="If set, participants will not be able to make submissions to this phase after this time.",
                        null=True,
                    ),
                ),
                (
                    "submission_page_html",
                    models.TextField(
                        blank=True,
                        help_text="HTML to include on the submission page for this challenge.",
                    ),
                ),
                (
                    "auto_publish_new_results",
                    models.BooleanField(
                        default=True,
                        help_text="If true, new results are automatically made public. If false, the challenge administrator must manually publish each new result.",
                    ),
                ),
                (
                    "display_all_metrics",
                    models.BooleanField(
                        default=True,
                        help_text="Should all of the metrics be displayed on the Result detail page?",
                    ),
                ),
                (
                    "evaluation_detail_observable_url",
                    models.URLField(
                        blank=True,
                        help_text="The URL of the embeddable observable notebook for viewing individual results. Must be of the form https://observablehq.com/embed/@user/notebook?cell=...",
                        max_length=2000,
                        validators=[
                            django.core.validators.RegexValidator(
                                "^https\\:\\/\\/observablehq\\.com\\/embed\\/\\@[^\\/]+\\/[^\\?\\.]+\\?cell\\=.*$",
                                "URL must be of the form https://observablehq.com/embed/@user/notebook?cell=*",
                            )
                        ],
                    ),
                ),
                (
                    "evaluation_comparison_observable_url",
                    models.URLField(
                        blank=True,
                        help_text="The URL of the embeddable observable notebook for comparingresults. Must be of the form https://observablehq.com/embed/@user/notebook?cell=...",
                        max_length=2000,
                        validators=[
                            django.core.validators.RegexValidator(
                                "^https\\:\\/\\/observablehq\\.com\\/embed\\/\\@[^\\/]+\\/[^\\?\\.]+\\?cell\\=.*$",
                                "URL must be of the form https://observablehq.com/embed/@user/notebook?cell=*",
                            )
                        ],
                    ),
                ),
                (
                    "archive",
                    models.ForeignKey(
                        blank=True,
                        help_text="Which archive should be used as the source dataset for this phase?",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="archives.archive",
                    ),
                ),
                (
                    "challenge",
                    models.ForeignKey(
                        editable=False,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="challenges.challenge",
                    ),
                ),
                (
                    "inputs",
                    models.ManyToManyField(
                        related_name="evaluation_inputs",
                        to="components.ComponentInterface",
                    ),
                ),
                (
                    "outputs",
                    models.ManyToManyField(
                        related_name="evaluation_outputs",
                        to="components.ComponentInterface",
                    ),
                ),
            ],
            options={
                "ordering": ("challenge", "submissions_open", "created"),
                "permissions": (
                    ("create_phase_submission", "Create Phase Submission"),
                ),
                "unique_together": {
                    ("challenge", "slug"),
                    ("challenge", "title"),
                },
            },
        ),
        migrations.CreateModel(
            name="Submission",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True)),
                ("modified", models.DateTimeField(auto_now=True)),
                (
                    "creators_ip",
                    models.GenericIPAddressField(
                        default=None, editable=False, null=True
                    ),
                ),
                (
                    "creators_user_agent",
                    models.TextField(blank=True, default="", editable=False),
                ),
                (
                    "predictions_file",
                    models.FileField(
                        blank=True,
                        storage=grandchallenge.core.storage.ProtectedS3Storage(),
                        upload_to=grandchallenge.evaluation.models.submission_file_path,
                        validators=[
                            grandchallenge.core.validators.MimeTypeValidator(
                                allowed_types=("application/zip", "text/plain")
                            ),
                            grandchallenge.core.validators.ExtensionValidator(
                                allowed_extensions=(".zip", ".csv")
                            ),
                        ],
                    ),
                ),
                (
                    "supplementary_file",
                    models.FileField(
                        blank=True,
                        storage=grandchallenge.core.storage.PublicS3Storage(),
                        upload_to=grandchallenge.evaluation.models.submission_supplementary_file_path,
                        validators=[
                            grandchallenge.core.validators.MimeTypeValidator(
                                allowed_types=("text/plain", "application/pdf")
                            )
                        ],
                    ),
                ),
                (
                    "comment",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text="You can add a comment here to help you keep track of your submissions.",
                        max_length=128,
                    ),
                ),
                (
                    "publication_url",
                    models.URLField(
                        blank=True,
                        help_text="A URL associated with this submission.",
                    ),
                ),
                (
                    "algorithm_image",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="algorithms.algorithmimage",
                    ),
                ),
                (
                    "creator",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "phase",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="evaluation.phase",
                    ),
                ),
            ],
            options={
                "unique_together": {
                    ("phase", "predictions_file", "algorithm_image")
                }
            },
        ),
        migrations.CreateModel(
            name="Method",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True)),
                ("modified", models.DateTimeField(auto_now=True)),
                (
                    "staged_image_uuid",
                    models.UUIDField(blank=True, editable=False, null=True),
                ),
                (
                    "image",
                    models.FileField(
                        blank=True,
                        help_text=".tar.xz archive of the container image produced from the command 'docker save IMAGE | xz -T0 -c > IMAGE.tar.xz'. See https://docs.docker.com/engine/reference/commandline/save/",
                        storage=grandchallenge.core.storage.PrivateS3Storage(),
                        upload_to=grandchallenge.components.models.docker_image_path,
                        validators=[
                            grandchallenge.core.validators.ExtensionValidator(
                                allowed_extensions=(
                                    ".tar",
                                    ".tar.gz",
                                    ".tar.xz",
                                )
                            )
                        ],
                    ),
                ),
                (
                    "image_sha256",
                    models.CharField(editable=False, max_length=71),
                ),
                (
                    "ready",
                    models.BooleanField(
                        default=False,
                        editable=False,
                        help_text="Is this image ready to be used?",
                    ),
                ),
                ("status", models.TextField(editable=False)),
                ("requires_gpu", models.BooleanField(default=False)),
                (
                    "requires_gpu_memory_gb",
                    models.PositiveIntegerField(default=4),
                ),
                ("requires_memory_gb", models.PositiveIntegerField(default=4)),
                (
                    "requires_cpu_cores",
                    models.DecimalField(
                        decimal_places=2, default=Decimal("1.0"), max_digits=4
                    ),
                ),
                (
                    "creator",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "phase",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="evaluation.phase",
                    ),
                ),
            ],
            options={"abstract": False},
        ),
        migrations.CreateModel(
            name="Evaluation",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True)),
                ("modified", models.DateTimeField(auto_now=True)),
                (
                    "status",
                    models.PositiveSmallIntegerField(
                        choices=[
                            (0, "Queued"),
                            (1, "Started"),
                            (2, "Re-Queued"),
                            (3, "Failed"),
                            (4, "Succeeded"),
                            (5, "Cancelled"),
                        ],
                        default=0,
                    ),
                ),
                ("stdout", models.TextField()),
                ("stderr", models.TextField(default="")),
                (
                    "error_message",
                    models.CharField(default="", max_length=1024),
                ),
                ("started_at", models.DateTimeField(null=True)),
                ("completed_at", models.DateTimeField(null=True)),
                ("published", models.BooleanField(default=True)),
                (
                    "rank",
                    models.PositiveIntegerField(
                        default=0,
                        help_text="The position of this result on the leaderboard. If the value is zero, then the result is unranked.",
                    ),
                ),
                ("rank_score", models.FloatField(default=0.0)),
                ("rank_per_metric", models.JSONField(default=dict)),
                (
                    "inputs",
                    models.ManyToManyField(
                        related_name="evaluation_evaluations_as_input",
                        to="components.ComponentInterfaceValue",
                    ),
                ),
                (
                    "method",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="evaluation.method",
                    ),
                ),
                (
                    "outputs",
                    models.ManyToManyField(
                        related_name="evaluation_evaluations_as_output",
                        to="components.ComponentInterfaceValue",
                    ),
                ),
                (
                    "submission",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="evaluation.submission",
                    ),
                ),
            ],
            options={"abstract": False},
        ),
        migrations.CreateModel(
            name="AlgorithmEvaluation",
            fields=[
                (
                    "status",
                    models.PositiveSmallIntegerField(
                        choices=[
                            (0, "Queued"),
                            (1, "Started"),
                            (2, "Re-Queued"),
                            (3, "Failed"),
                            (4, "Succeeded"),
                            (5, "Cancelled"),
                        ],
                        default=0,
                    ),
                ),
                ("stdout", models.TextField()),
                ("stderr", models.TextField(default="")),
                (
                    "error_message",
                    models.CharField(default="", max_length=1024),
                ),
                ("started_at", models.DateTimeField(null=True)),
                ("completed_at", models.DateTimeField(null=True)),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                ("created", models.DateTimeField(auto_now_add=True)),
                ("modified", models.DateTimeField(auto_now=True)),
                (
                    "inputs",
                    models.ManyToManyField(
                        related_name="evaluation_algorithmevaluations_as_input",
                        to="components.ComponentInterfaceValue",
                    ),
                ),
                (
                    "outputs",
                    models.ManyToManyField(
                        related_name="evaluation_algorithmevaluations_as_output",
                        to="components.ComponentInterfaceValue",
                    ),
                ),
                (
                    "submission",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="evaluation.submission",
                    ),
                ),
            ],
            options={"abstract": False},
        ),
    ]
