# Generated by Django 4.1.10 on 2023-07-17 14:52

from django.db import migrations, models

import grandchallenge.core.validators


class Migration(migrations.Migration):

    dependencies = [
        ("components", "0014_alter_componentinterface_kind"),
    ]

    operations = [
        migrations.AlterField(
            model_name="componentinterface",
            name="overlay_segments",
            field=models.JSONField(
                blank=True,
                default=list,
                help_text="The schema that defines how categories of values in the overlay images are differentiated.",
                validators=[
                    grandchallenge.core.validators.JSONValidator(
                        schema={
                            "$id": "http://example.com/example.json",
                            "$schema": "http://json-schema.org/draft-06/schema",
                            "description": "Define the overlay segments for the LUT.",
                            "items": {
                                "$id": "#/items",
                                "additionalProperties": False,
                                "default": {},
                                "description": "Defines what each segment of the LUT represents.",
                                "examples": [
                                    {
                                        "metric_template": "{{metrics.volumes[0]}} mm³",
                                        "name": "Metastasis",
                                        "visible": True,
                                        "voxel_value": 1,
                                    }
                                ],
                                "maxItems": 64,
                                "properties": {
                                    "metric_template": {
                                        "$id": "#/items/properties/metric_template",
                                        "default": "",
                                        "description": "The jinja template to determine which property from the results.json should be used as the label text.",
                                        "examples": [
                                            "{{metrics.volumes[0]}} mm³"
                                        ],
                                        "title": "The Metric Template Schema",
                                        "type": "string",
                                    },
                                    "name": {
                                        "$id": "#/items/properties/name",
                                        "default": "",
                                        "description": "What this segment should be called.",
                                        "examples": ["Metastasis"],
                                        "title": "The Name Schema",
                                        "type": "string",
                                    },
                                    "visible": {
                                        "$id": "#/items/properties/visible",
                                        "default": True,
                                        "description": "Whether this segment is visible by default.",
                                        "examples": [True],
                                        "title": "The Visible Schema",
                                        "type": "boolean",
                                    },
                                    "voxel_value": {
                                        "$id": "#/items/properties/voxel_value",
                                        "default": 0,
                                        "description": "The value of the LUT for this segment.",
                                        "examples": [1],
                                        "title": "The Voxel Value Schema",
                                        "type": "integer",
                                    },
                                },
                                "required": ["voxel_value", "name", "visible"],
                                "title": "The Segment Schema",
                                "type": "object",
                            },
                            "title": "The Overlay Segments Schema",
                            "type": "array",
                        }
                    )
                ],
            ),
        ),
    ]
