# Generated by Django 3.1.1 on 2021-02-03 07:47

import django.db.models.deletion
from django.db import migrations, models

import grandchallenge.components.models
import grandchallenge.core.storage
import grandchallenge.core.validators


class Migration(migrations.Migration):

    dependencies = [("cases", "0001_initial"), ("components", "0001_initial")]

    operations = [
        migrations.AddField(
            model_name="componentinterface",
            name="store_in_database",
            field=models.BooleanField(
                default=True,
                editable=False,
                help_text="Should the value be saved in a database field, only valid for outputs.",
            ),
        ),
        migrations.AlterField(
            model_name="componentinterfacevalue",
            name="file",
            field=models.FileField(
                blank=True,
                null=True,
                storage=grandchallenge.core.storage.ProtectedS3Storage(),
                upload_to=grandchallenge.components.models.component_interface_value_path,
                validators=[
                    grandchallenge.core.validators.ExtensionValidator(
                        allowed_extensions=(".json", ".zip", ".csv")
                    ),
                    grandchallenge.core.validators.MimeTypeValidator(
                        allowed_types=(
                            "application/json",
                            "application/zip",
                            "text/plain",
                            "application/csv",
                        )
                    ),
                ],
            ),
        ),
        migrations.AlterField(
            model_name="componentinterfacevalue",
            name="image",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to="cases.image",
            ),
        ),
        migrations.AlterField(
            model_name="componentinterfacevalue",
            name="value",
            field=models.JSONField(blank=True, default=None, null=True),
        ),
    ]
