# Generated by Django 3.1.11 on 2021-07-03 09:57

import uuid

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ("github", "0002_auto_20210630_1807"),
        ("algorithms", "0010_algorithm_repo_name"),
    ]

    operations = [
        migrations.CreateModel(
            name="Build",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True)),
                ("modified", models.DateTimeField(auto_now=True)),
                ("build_config", models.JSONField()),
                ("build_id", models.CharField(max_length=1024)),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("SUCCEEDED", "Succeeded"),
                            ("FAILED", "Failed"),
                            ("FAULT", "Fault"),
                            ("TIMED_OUT", "Timed Out"),
                            ("IN_PROGRESS", "In Progress"),
                            ("STOPPED", "Stopped"),
                        ],
                        max_length=11,
                    ),
                ),
                ("build_log", models.TextField(blank=True)),
                (
                    "algorithm_image",
                    models.OneToOneField(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="algorithms.algorithmimage",
                    ),
                ),
                (
                    "webhook_message",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="github.githubwebhookmessage",
                    ),
                ),
            ],
        ),
        migrations.AddIndex(
            model_name="build",
            index=models.Index(
                fields=["build_id"], name="codebuild_b_build_i_c5a93f_idx"
            ),
        ),
    ]
