# Generated by Django 3.2.16 on 2023-01-23 14:06

import django.core.validators
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ("challenges", "0025_auto_20230112_1003"),
    ]

    operations = [
        migrations.AlterField(
            model_name="challengerequest",
            name="average_algorithm_container_size_in_gb",
            field=models.PositiveIntegerField(
                default=6,
                help_text="Average algorithm container size in GB.",
                validators=[
                    django.core.validators.MinValueValidator(limit_value=1)
                ],
            ),
        ),
        migrations.AlterField(
            model_name="challengerequest",
            name="average_number_of_containers_per_team",
            field=models.PositiveIntegerField(
                default=5,
                help_text="Average number of algorithm containers per team.",
                validators=[
                    django.core.validators.MinValueValidator(limit_value=1)
                ],
            ),
        ),
        migrations.AlterField(
            model_name="challengerequest",
            name="average_size_of_test_image_in_mb",
            field=models.PositiveIntegerField(
                blank=True,
                help_text="Average size of a test image in MB.",
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(limit_value=1),
                    django.core.validators.MaxValueValidator(
                        limit_value=10000
                    ),
                ],
            ),
        ),
        migrations.AlterField(
            model_name="challengerequest",
            name="budget_for_hosting_challenge",
            field=models.PositiveIntegerField(
                blank=True,
                default=0,
                help_text="What is your budget for hosting this challenge? Please be reminded of our <a href='/challenge-policy-and-pricing/'>challenge pricing policy</a>.",
                null=True,
            ),
        ),
        migrations.AlterField(
            model_name="challengerequest",
            name="expected_number_of_teams",
            field=models.PositiveIntegerField(
                help_text="How many teams do you expect to participate in your challenge?",
                validators=[
                    django.core.validators.MinValueValidator(limit_value=1)
                ],
            ),
        ),
        migrations.AlterField(
            model_name="challengerequest",
            name="inference_time_limit_in_minutes",
            field=models.PositiveIntegerField(
                blank=True,
                help_text="Average run time per algorithm job in minutes.",
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(limit_value=1),
                    django.core.validators.MaxValueValidator(limit_value=60),
                ],
            ),
        ),
        migrations.AlterField(
            model_name="challengerequest",
            name="number_of_tasks",
            field=models.PositiveIntegerField(
                default=1,
                help_text="If your challenge has multiple tasks, we multiply the phase 1 and 2 cost estimates by the number of tasks.",
                validators=[
                    django.core.validators.MinValueValidator(limit_value=1)
                ],
            ),
        ),
        migrations.AlterField(
            model_name="challengerequest",
            name="phase_1_number_of_submissions_per_team",
            field=models.PositiveIntegerField(
                blank=True,
                help_text="How many submissions do you expect per team in this phase?",
                null=True,
            ),
        ),
        migrations.AlterField(
            model_name="challengerequest",
            name="phase_1_number_of_test_images",
            field=models.PositiveIntegerField(
                blank=True,
                help_text="Number of test images for this phase.",
                null=True,
            ),
        ),
        migrations.AlterField(
            model_name="challengerequest",
            name="phase_2_number_of_submissions_per_team",
            field=models.PositiveIntegerField(
                blank=True,
                help_text="How many submissions do you expect per team in this phase?",
                null=True,
            ),
        ),
        migrations.AlterField(
            model_name="challengerequest",
            name="phase_2_number_of_test_images",
            field=models.PositiveIntegerField(
                blank=True,
                help_text="Number of test images for this phase.",
                null=True,
            ),
        ),
    ]
