# Generated by Django 3.2.12 on 2022-03-10 11:27

import re
import uuid

import django.contrib.postgres.fields.citext
import django.core.validators
import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models

import grandchallenge.challenges.models
import grandchallenge.core.storage
import grandchallenge.core.validators


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("modalities", "0001_initial"),
        ("anatomy", "0001_initial"),
        ("task_categories", "0001_initial"),
        ("challenges", "0012_alter_challenge_require_participant_review"),
    ]

    operations = [
        migrations.CreateModel(
            name="ChallengeRequest",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True)),
                ("modified", models.DateTimeField(auto_now=True)),
                (
                    "short_name",
                    django.contrib.postgres.fields.citext.CICharField(
                        help_text="short name used in url, specific css, files etc. No spaces allowed",
                        max_length=50,
                        unique=True,
                        validators=[
                            grandchallenge.challenges.models.validate_nounderscores,
                            django.core.validators.RegexValidator(
                                re.compile("^[-a-zA-Z0-9_]+\\Z"),
                                "Enter a valid “slug” consisting of letters, numbers, underscores or hyphens.",
                                "invalid",
                            ),
                            grandchallenge.challenges.models.validate_short_name,
                        ],
                    ),
                ),
                (
                    "title",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text="The name of the challenge that is displayed on the All Challenges page. If this is blank the short name of the challenge will be used.",
                        max_length=64,
                    ),
                ),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("ACPT", "Accepted"),
                            ("RJCT", "Rejected"),
                            ("PEND", "Pending"),
                        ],
                        default="PEND",
                        max_length=4,
                    ),
                ),
                (
                    "abstract",
                    models.TextField(
                        help_text="Provide a summary of the challenge purpose."
                    ),
                ),
                (
                    "contact_email",
                    models.EmailField(
                        help_text="Please provide an email that our team can use to contact you should there be any questions about your request.",
                        max_length=254,
                    ),
                ),
                (
                    "start_date",
                    models.DateField(
                        help_text="Estimated start date for this challenge."
                    ),
                ),
                (
                    "end_date",
                    models.DateField(
                        help_text="Estimated end date for this challenge. Please note that we aim to keep challenges open for submission for at least 3 years after the official end date if possible."
                    ),
                ),
                (
                    "organizers",
                    models.TextField(
                        help_text="Provide information about the organizing team (names and affiliations)"
                    ),
                ),
                (
                    "affiliated_event",
                    models.CharField(
                        blank=True,
                        help_text="Is this challenge part of a workshop or conference? If so, which one?",
                        max_length=50,
                    ),
                ),
                (
                    "structured_challenge_submission_form",
                    models.FileField(
                        blank=True,
                        null=True,
                        storage=grandchallenge.core.storage.ProtectedS3Storage(),
                        upload_to=grandchallenge.challenges.models.submission_pdf_path,
                        validators=[
                            grandchallenge.core.validators.ExtensionValidator(
                                allowed_extensions=(".pdf",)
                            ),
                            grandchallenge.core.validators.MimeTypeValidator(
                                allowed_types=("application/pdf",)
                            ),
                        ],
                    ),
                ),
                (
                    "challenge_type",
                    models.PositiveSmallIntegerField(
                        choices=[
                            (1, "Type 1 - prediction submission"),
                            (2, "Type 2 - algorithm submission"),
                        ],
                        default=2,
                        help_text="What type is this challenge?",
                    ),
                ),
                (
                    "challenge_setup",
                    models.TextField(
                        help_text="Describe the challenge set-up."
                    ),
                ),
                (
                    "data_set",
                    models.TextField(
                        help_text="Describe the training and test datasets you are planning to use."
                    ),
                ),
                (
                    "submission_assessment",
                    models.TextField(
                        help_text="Define the metrics you will use to assess and rank participants’ submissions."
                    ),
                ),
                (
                    "challenge_publication",
                    models.TextField(
                        help_text="Please indicate if you plan to coordinate a publication of the challenge results."
                    ),
                ),
                (
                    "code_availability",
                    models.TextField(
                        help_text="Will the participants’ code be accessible after the challenge?"
                    ),
                ),
                (
                    "expected_number_of_teams",
                    models.IntegerField(
                        help_text="How many teams do you expect to participate in your challenge?"
                    ),
                ),
                (
                    "average_algorithm_container_size_in_gb",
                    models.IntegerField(
                        default=10,
                        help_text="Average algorithm container size in GB.",
                    ),
                ),
                (
                    "average_number_of_containers_per_team",
                    models.IntegerField(
                        default=10,
                        help_text="Average number of algorithm containers per team.",
                    ),
                ),
                (
                    "inference_time_limit_in_minutes",
                    models.IntegerField(
                        blank=True,
                        help_text="Time limit per inference job in minutes.",
                        null=True,
                    ),
                ),
                (
                    "average_size_of_test_image_in_mb",
                    models.IntegerField(
                        blank=True,
                        help_text="Average size of a test image in MB.",
                        null=True,
                    ),
                ),
                (
                    "phase_1_number_of_submissions_per_team",
                    models.IntegerField(
                        blank=True,
                        help_text="How many submissions will teams be allowed to make to this phase?",
                        null=True,
                    ),
                ),
                (
                    "phase_2_number_of_submissions_per_team",
                    models.IntegerField(
                        blank=True,
                        help_text="How many submissions will teams be allowed to make to this phase?",
                        null=True,
                    ),
                ),
                (
                    "phase_1_number_of_test_images",
                    models.IntegerField(
                        blank=True,
                        help_text="Number of test images for this phase.",
                        null=True,
                    ),
                ),
                (
                    "phase_2_number_of_test_images",
                    models.IntegerField(
                        blank=True,
                        help_text="Number of test images for this phase.",
                        null=True,
                    ),
                ),
                (
                    "number_of_tasks",
                    models.IntegerField(
                        default=1,
                        help_text="If your challenge has multiple tasks, we multiply the phase 1 and 2 cost estimates by the number of tasks.",
                    ),
                ),
                (
                    "budget_for_hosting_challenge",
                    models.IntegerField(
                        blank=True,
                        default=0,
                        help_text="What is your budget for hosting this challenge, if any?",
                        null=True,
                    ),
                ),
                (
                    "creator",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "modalities",
                    models.ManyToManyField(
                        blank=True,
                        help_text="What imaging modalities are used in this challenge?",
                        to="modalities.ImagingModality",
                    ),
                ),
                (
                    "structures",
                    models.ManyToManyField(
                        blank=True,
                        help_text="What structures are used in this challenge?",
                        to="anatomy.BodyStructure",
                    ),
                ),
                (
                    "task_types",
                    models.ManyToManyField(
                        blank=True,
                        help_text="What type of task is this challenge?",
                        to="task_categories.TaskType",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
    ]
