# Generated by Django 3.1.1 on 2020-12-02 13:26

import uuid

import django.db.models.deletion
import django_extensions.db.fields
from django.conf import settings
from django.db import migrations, models

import grandchallenge.core.storage


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("algorithms", "0001_initial"),
        ("workstation_configs", "0001_squashed_0008_auto_20201001_0758"),
        ("workstations", "0001_squashed_0011_auto_20201001_0758"),
        ("cases", "0001_initial"),
        ("auth", "0012_alter_user_first_name_max_length"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="Archive",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True)),
                ("modified", models.DateTimeField(auto_now=True)),
                (
                    "title",
                    models.CharField(max_length=255, verbose_name="title"),
                ),
                (
                    "description",
                    models.TextField(
                        blank=True, null=True, verbose_name="description"
                    ),
                ),
                (
                    "slug",
                    django_extensions.db.fields.AutoSlugField(
                        blank=True,
                        editable=False,
                        populate_from="title",
                        verbose_name="slug",
                    ),
                ),
                ("detail_page_markdown", models.TextField(blank=True)),
                (
                    "logo",
                    models.ImageField(
                        null=True,
                        storage=grandchallenge.core.storage.PublicS3Storage(),
                        upload_to=grandchallenge.core.storage.get_logo_path,
                    ),
                ),
                ("public", models.BooleanField(default=False)),
                (
                    "algorithms",
                    models.ManyToManyField(
                        blank=True,
                        help_text="Algorithms that will be executed on all images in this archive",
                        to="algorithms.Algorithm",
                    ),
                ),
                (
                    "editors_group",
                    models.OneToOneField(
                        editable=False,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="editors_of_archive",
                        to="auth.group",
                    ),
                ),
                ("images", models.ManyToManyField(to="cases.Image")),
                (
                    "uploaders_group",
                    models.OneToOneField(
                        editable=False,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="uploaders_of_archive",
                        to="auth.group",
                    ),
                ),
                (
                    "users_group",
                    models.OneToOneField(
                        editable=False,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="users_of_archive",
                        to="auth.group",
                    ),
                ),
                (
                    "workstation",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="workstations.workstation",
                    ),
                ),
                (
                    "workstation_config",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="workstation_configs.workstationconfig",
                    ),
                ),
            ],
            options={
                "ordering": ("created",),
                "permissions": [("upload_archive", "Can upload to archive")],
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="ArchivePermissionRequest",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True)),
                ("changed", models.DateTimeField(auto_now=True)),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("PEND", "Pending"),
                            ("ACPT", "Accepted"),
                            ("RJCT", "Rejected"),
                        ],
                        default="PEND",
                        max_length=4,
                    ),
                ),
                (
                    "rejection_text",
                    models.TextField(
                        blank=True,
                        help_text="The text that will be sent to the user with the reason for their rejection.",
                    ),
                ),
                (
                    "archive",
                    models.ForeignKey(
                        help_text="To which archive has the user requested access?",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="archives.archive",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        help_text="which user requested to participate?",
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "abstract": False,
                "unique_together": {("archive", "user")},
            },
        ),
    ]
