function c_pool = MAX_constants()

%% constants used for the simulation of the model MAX stand

% Copyright 2023 Collaborative Research Centre Transregio 96 (CRC/TR 96)
%
% Redistribution and use in source and binary forms, with or without
% modification, are permitted provided that the following conditions are
% met:
%
% 1. Redistributions of source code must retain the above copyright notice,
% this list of conditions and the following disclaimer.
%
% 2. Redistributions in binary form must reproduce the above copyright
% notice, this list of conditions and the following disclaimer in the
% documentation and/or other materials provided with the distribution.
%
% THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
% "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
% TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
% PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER
% OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
% EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
% PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
% PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
% LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
% NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
% SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

%% constants already included in the matrices
%rho    = 14000;    % density [kg/m^3]
%cp     = 250;      % specific heat capacity [J/kg/K]
%lambda = 80;       % heat conductivity [W/m/K]
%alphaa = 15;       % heat transfer coefficient [W/m^2/K]

%% constants for simulation
%------------------------- spindle --------------------------------
c_pool.sp_ASegment = pi*20*20*1e-6;                   % area of spindle segment
c_pool.sp_p        = 0.02;                            % slope
c_pool.sp_d        = 0.02;                            % diameter of the spindle

%--------------------------- nut -------------------------------
c_pool.mu_d_wk  = 0.0035;                             % diameter of rolling body
c_pool.mu_alpha = pi/4;                               % angle of pressure
c_pool.sp_p     = 0.02;                               % slope
c_pool.sp_d     = 0.02;                               % diameter of the spindle
c_pool.mu_i_u   = 2;                                  % load-bearing Umlaufe
c_pool.mu_i_wk  = c_pool.mu_i_u*sqrt(c_pool.sp_p^2+...
                (pi*c_pool.sp_d)^2)/c_pool.mu_d_wk;   % load-bearing number of rolling bodies
c_pool.mu_C_0   = 9100;                               % dynamic load rating
c_pool.mu_K_v   = 0.03;                               % class of initial tension
c_pool.mu_F_v   = c_pool.mu_K_v*c_pool.mu_C_0;        % initial tension
c_pool.mu_M_d   = 0.12;                               % friction moment of seal
c_pool.mu_M_w   = 4.52e5*c_pool.sp_d^1.44*...
                c_pool.mu_d_wk^1.33*c_pool.mu_i_u*...
                c_pool.mu_F_v/c_pool.mu_C_0;          % friction moment of rolling contact
c_pool.mu_M     = c_pool.mu_M_w+c_pool.mu_M_d;        % nut: total moment
c_pool.mu_A     = pi*20*57*1e-6;                      % nut: total area of friction

%------------------------- bearing -------------------------------
c_pool.l_beta_d = 2;                                  % coefficient (taken from literature)
c_pool.l_K_s1   = 0.014;                              % coefficient (taken from literature)
c_pool.l_K_s2   = 10;                                 % coefficient (taken from literature)
c_pool.l_d_dl   = 0.025;                              % diameter sealing lip
c_pool.l_M_d    = (c_pool.l_K_s1*...
                (c_pool.l_d_dl*1000)^c_pool.l_beta_d+...
                c_pool.l_K_s2)/1000;                  % seal friction in bearing
  
c_pool.l_i_wk   = 9;                                  % number of rolling bodies
c_pool.l_ny_40  = 95e-6;                              % viscosity of oil
c_pool.l_d_a    = 0.042;                              % outer diameter
c_pool.l_d_i    = 0.012;                              % inner diameter
c_pool.l_d_m    = (c_pool.l_d_a+c_pool.l_d_i)/2;      % average diameter         
c_pool.l_d_wk   = 0.00635;                            % diameter of rolling body
c_pool.l_F_a    = 5038;                               % axial initial tension
c_pool.l_F_r    = 150;                                % radial initial tension
c_pool.l_C_0a   = 24700;                              % static load rating
c_pool.l_f_0    = 4;                                  % coefficient (taken from literature)
c_pool.l_f_1    = 0.00046;                            % coefficient (taken from literature)
c_pool.l_X_0    = 1;                                  % coefficient (taken from ISO76)    
c_pool.l_Y_0    = 0.2;                                % coefficient (taken from ISO76)
c_pool.l_P_1    = 1.4*c_pool.l_F_a-0.1*c_pool.l_F_r;  % standard load
c_pool.l_M_1    = c_pool.l_f_1*c_pool.l_P_1*c_pool.l_d_m;
c_pool.l_A      = pi*c_pool.l_d_m*25e-3;              % bearing: total area of friction

%--------------------------- motor -----------------------------------------------
c_pool.mo_AStator  = pi*20*142*1e-6;   % surface area with heat loss of stator 
c_pool.mo_ARotor   = pi*10^2*1e-6;     % surface area with heat loss of rotor

%-------------------------- factors ---------------------------------------------
c_pool.mu_factor1 = 1.5;

c_pool.Anteil_rotor   = 1/2;    % part of surface area rotor
c_pool.Anteil_stator = 1/2;     % part of surface area stator
