## ----globalOpts, include=FALSE------------------------------------------
library(knitr)
opts_chunk$set(concordance = TRUE,
               fig.align = "center",
               out.width = "1.2\\linewidth", ## default is 1 
               tidy = FALSE,
               comment = NA,
               fig.path = "Rmd_files/Rmd_Figures/Modelling/", 
               cache.path = "Rmd_files/Cache/Modelling/",
               # dev = "png",
               fig.pos = "H",
               crop = hook_pdfcrop) ## changes mar defaults...
##
options(digits = 8)


## ----Checkpoint, message=FALSE------------------------------------------
## (messages are omitted in this chunk)
##
# library(checkpoint)
# checkpoint(snapshot_date = "2022-11-15") 


## ----loadPackages, message=FALSE----------------------------------------
## (messages are omitted from this chunk)
##
library(dplyr)
library(kableExtra)
library(ggplot2)
library(tibble) ## function rownames_to_column()
library(multcomp)
library(mgcv)


## ----Settings-----------------------------------------------------------
Sys.setenv(lang = "en_US")
theme_set(theme_bw())

if (!dir.exists("Prepared_data_and_models")) {
  dir.create("Prepared_data_and_models")
}


## ----getData------------------------------------------------------------
d.maize <- readRDS(file = paste0("Prepared_data_and_models/", 
                                "d.maize_PreparedData.RDS"))


## ----OverviewHeadStr----------------------------------------------------
dim(d.maize)
head(d.maize)[1:min(ncol(d.maize), 30)]
str(d.maize)


## ----createWellsMatrix, echo=FALSE--------------------------------------
## (this chunk is not echoed)
##
M.wells <- matrix(data = letters[1:6], 
                  byrow = TRUE,
                  nrow = 3, ncol = 2)[c(3:1), ]
M.wells


## ----createPotsOnTableMatrix, echo=FALSE--------------------------------
## (this chunk is not echoed)
##
M.pots_on_table <- matrix(data = paste0(rep(LETTERS[1:3], each = 6),
                                        1:6), 
                          byrow = TRUE,
                          nrow = 3, ncol = 6)[c(3:1), ]
M.pots_on_table


## ----surv.days.to.germ--------------------------------------------------
gam.height_2022_07_05.num <- gam(height_2022_07_05.num ~ 
                                   s(position_field_x_cm, 
                                     position_field_y_cm) +
                                   soil.fac +
                                   depth +
                                   seed.weight,
                                 data = d.maize)

##
summary(gam.height_2022_07_05.num)
plot(gam.height_2022_07_05.num)


## ----surv.days.to.germ2-------------------------------------------------
# The response variable is amount, thus we log transform it and refit the model
gam.height_2022_07_05.num.log <- gam(log(height_2022_07_05.num) ~ 
                                       s(position_field_x_cm,
                                         position_field_y_cm) +
                                       soil.fac +
                                       depth +
                                       seed.weight,
                                     data = d.maize)
##
summary(gam.height_2022_07_05.num.log)
plot(gam.height_2022_07_05.num.log)


## -----------------------------------------------------------------------
gam.check(gam.height_2022_07_05.num)


## -----------------------------------------------------------------------
gam.check(gam.height_2022_07_05.num.log)


## ----additiveSmooth-----------------------------------------------------
options(tinytex.verbose = TRUE)
k.x <- d.maize %>% 
  pull(position_field_x_cm) %>% 
  n_distinct()
k.y <- d.maize %>% 
  pull(position_field_y_cm) %>% 
  n_distinct()
gam.height_2022_07_05.num.add <- gam(height_2022_07_05.num ~
                                       s(position_field_x_cm,
                                         k = k.x - 1) +
                                       s(position_field_y_cm, k = k.y) +
                                       soil.fac +
                                       depth +
                                       seed.weight,
                                     data = d.maize)
summary(gam.height_2022_07_05.num.add)
plot(gam.height_2022_07_05.num.add)


## ----linear-------------------------------------------------------------
gam.height_2022_07_05.num.lin <- gam(height_2022_07_05.num ~ 
                                       position_field_x_cm + 
                                       s(position_field_y_cm) +
                                       soil.fac +
                                       depth +
                                       seed.weight,
                                     data = d.maize)
##
summary(gam.height_2022_07_05.num.lin)
plot(gam.height_2022_07_05.num.lin)


## -----------------------------------------------------------------------
cbind(AIC(gam.height_2022_07_05.num, 
          gam.height_2022_07_05.num.add, 
          gam.height_2022_07_05.num.lin),
      ##
      BIC(gam.height_2022_07_05.num,
          gam.height_2022_07_05.num.add,
          gam.height_2022_07_05.num.lin))


## -----------------------------------------------------------------------
gam.height_2022_07_05.num.lin_reduced <- gam(height_2022_07_05.num ~ 
                                               position_field_x_cm + 
                                               s(position_field_y_cm) +
                                               depth +
                                               seed.weight,
                                             data = d.maize)
##
anova(gam.height_2022_07_05.num.lin, 
      gam.height_2022_07_05.num.lin_reduced, test = "Chisq")


## -----------------------------------------------------------------------
gam.check(gam.height_2022_07_05.num.lin)


## ----citations----------------------------------------------------------
citation()
citation("mgcv")


## ----sessionInfo--------------------------------------------------------
sessionInfo()

