## ----globalOpts, include=FALSE------------------------------------------
library(knitr)
opts_chunk$set(concordance = TRUE,
               fig.align = "center",
               out.width = "1.2\\linewidth", ## default is 1 
               tidy = FALSE,
               comment = NA,
               fig.path = "Rmd_files/Rmd_Figures/Modelling/", 
               cache.path = "Rmd_files/Cache/Modelling/",
               # dev = "png",
               fig.pos = "H",
               crop = hook_pdfcrop) ## changes mar defaults...
##
options(digits = 8)


## ----Checkpoint, message=FALSE------------------------------------------
## (messages are omitted in this chunk)
##
# library(checkpoint)
# checkpoint(snapshot_date = "2022-11-15") 


## ----loadPackages, message=FALSE----------------------------------------
## (messages are omitted from this chunk)
##
library(dplyr)
library(kableExtra)
library(ggplot2)
library(tibble) ## function rownames_to_column()
library(multcomp)
library(lme4)
library(mgcv)
# library(AICcmodavg)


## ----Settings-----------------------------------------------------------
Sys.setenv(lang = "en_US")
theme_set(theme_bw())

if (!dir.exists("Prepared_data_and_models")) {
  dir.create("Prepared_data_and_models")
}


## ----getData------------------------------------------------------------
d.maize <- readRDS(file = paste0("Prepared_data_and_models/", 
                                "d.maize_PreparedData.RDS"))


## ----OverviewHeadStr----------------------------------------------------
dim(d.maize)
head(d.maize)[1:min(ncol(d.maize), 30)]
str(d.maize)


## ----createWellsMatrix, echo=FALSE--------------------------------------
## (this chunk is not echoed)
##
M.wells <- matrix(data = letters[1:6], 
                  byrow = TRUE,
                  nrow = 3, ncol = 2)[c(3:1), ]
M.wells


## ----createPotsOnTableMatrix, echo=FALSE--------------------------------
## (this chunk is not echoed)
##
M.pots_on_table <- matrix(data = paste0(rep(LETTERS[1:3], each = 6),
                                        1:6), 
                          byrow = TRUE,
                          nrow = 3, ncol = 6)[c(3:1), ]
M.pots_on_table


## ----surv.days.to.germ--------------------------------------------------
gam.days.to.germination <- gam(days.to.germination ~ 
                                 s(seed_coord_x, 
                                   seed_coord_y) +
                                 soil.fac +
                                 depth +
                                 seed.weight,
                               data = d.maize)

##
summary(gam.days.to.germination)
plot(gam.days.to.germination)


## ----additiveSmooth-----------------------------------------------------
k.x <- d.maize %>% 
  pull(seed_coord_x) %>% 
  n_distinct()
k.y <- d.maize %>% 
  pull(seed_coord_y) %>% 
  n_distinct()
gam.days.to.germination.add <- gam(days.to.germination ~ s(seed_coord_x, k = k.x) + 
                                     s(seed_coord_y, k = k.y) +
                                     soil.fac +
                                     depth +
                                     seed.weight,
                                   data = d.maize)
summary(gam.days.to.germination.add)
plot(gam.days.to.germination.add)


## -----------------------------------------------------------------------
AIC(gam.days.to.germination.add, 
    gam.days.to.germination)
##
BIC(gam.days.to.germination.add,
    gam.days.to.germination)


## -----------------------------------------------------------------------
gam.days.to.germination.add.reduced <- gam(days.to.germination ~ s(seed_coord_x, k = k.x) + 
                                             s(seed_coord_y, k = k.y) +
                                             depth +
                                             seed.weight,
                                           data = d.maize)
##
anova(gam.days.to.germination.add, gam.days.to.germination.add.reduced, test = "Chisq")


## -----------------------------------------------------------------------
set.seed(12)
gam.check(gam.days.to.germination.add)


## ----citations----------------------------------------------------------
citation()
citation("mgcv")


## ----sessionInfo--------------------------------------------------------
sessionInfo()

