# <i>Movie Recommendation 🎥 </i>


<h2 style="text-align: center; color:#9EF8EE">A Collaborative Filtering-Based Recommendation System<h2>

[![ForTheBadge built-with-love](http://ForTheBadge.com/images/badges/built-with-love.svg)](https://github.com/AtharvaThorve)

[![Maintenance](https://img.shields.io/badge/Maintained%3F-yes-green.svg)](https://github.com/raghavnarula/MovieRecommender/graphs/commit-activity)
[![Contributors Activity](https://img.shields.io/github/commit-activity/m/raghavnarula/MovieRecommender)](https://github.com/raghavnarula/MovieRecommender/pulse)
![Test Workflow](https://github.com/raghavnarula/MovieRecommender/actions/workflows/test.yml/badge.svg)
[![GitHub issues](https://img.shields.io/github/issues/raghavnarula/MovieRecommender.svg)](https://github.com/raghavnarula/MovieRecommender/issues)
[![GitHub issues-closed](https://img.shields.io/github/issues-closed/raghavnarula/MovieRecommender.svg)](https://github.com/raghavnarula/MovieRecommender/issues?q=is%3Aissue+is%3Aclosed)
[![PRs Welcome](https://img.shields.io/badge/PRs-welcome-brightgreen.svg?style=flat-square)](http://makeapullrequest.com)
![Code Coverage](https://img.shields.io/badge/coverage-99.4%25-light_green)
[![License: MIT](https://img.shields.io/badge/License-MIT-red.svg)](https://opensource.org/licenses/MIT)
[![DOI](https://zenodo.org/badge/DOI/10.5281/zenodo.8432874.svg)](https://doi.org/10.5281/zenodo.8432874)
[![GitHub release](https://img.shields.io/github/tag/raghavnarula/MovieRecommender.svg )](https://github.com/raghavnarula/MovieRecommender/tags)
[![black](https://img.shields.io/badge/StyleChecker-black-purple.svg)](https://pypi.org/project/black/)

<h2>Project 3 Plan</h2>

(Please see [wiki](https://github.com/raghavnarula/MovieRecommender/wiki/Project-3-Plan) for detailed information.)

Testing how good the Movie Recommender is :

1. Pick 10-15 very famous movies.
2. Make sure the movies have diversity based on genre, cast, and production style.
3. Show users a set of the top 5 movies recommended by the Movie Recommender.
4. Let the user give a rating out of 5 and write comments about the movie.
5. Collect the ratings and improve the collaborative filtering model to give better predictions to other users.
6. Perform Sentiment analysis on the comments written by the user and determine whether the comment is positive, critical, or neutral.

Note: Our system can be virtually uploaded to sites like [Code SandBox](https://codesandbox.io/), for easier testing.

<h2>Tech stack 👨‍💻</h2>

|<img src="images/python.svg">     | <img src="images/flask.svg">      | <img src="images/html5.svg">         |<img src="images/css3.svg">       | <img src="images/javascript.svg">        | 
| -------- | ------- | -------- | ------- | -------|
| Python | Flask     | HTML | CSS     | Javascript |


<h2>Video ▶️</h2>

https://github.com/raghavnarula/MovieRecommender/assets/48481966/7e36e523-a48d-4342-869a-c676c329ab23




<h2>Working 📱</h2>


https://github.com/raghavnarula/MovieRecommender/assets/48481966/2c0e8702-bbf7-43c4-b703-1b3681b58925

<h2>Requirements and Setup ⚙️</h2>

- Python 3.9 + [Install Python On Your System](https://docs.python.org/3.9/using/index.html)
- Setup a Virtual Environment in Python [Setup Virtualenv](https://docs.python.org/3/library/venv.html) 
- Activate Virtualenv
  * <strong>Linux / Unix</strong>

  ``` bash
      source env/bin/activate
  ```
  * <strong>Windows</strong>
  ``` cmd
    venv\Scripts\activate
  ```  
- Style check - black
  ``` bash
  pip install black
  ```
- Install Static Code Analyser Pylance in your Favourite IDE/ Text Editor <strong>(Optional)</strong>

- Install all required Python packages
  ``` bash
  pip install -r requirements.txt
  ```
<h2>Usage</h2>

``` bash
cd Code/recommenderapp
python3 app.py
```
![Execution](https://raw.githubusercontent.com/git-ankit/MovieRecommender/master/asset/execution.gif)

<h2>Documentation 📚</h2>

Refer to the Wiki page [here](https://github.com/raghavnarula/MovieRecommender/wiki/Documentation)

<h2>Bug? 🐛</h2>
Raise a issue on this repository, we would love to look at it ❤️
  
## Contributions to the Project
Please refer to the [Contributing.md](https://github.com/raghavnarula/MovieRecommender/blob/master/CONTRIBUTING.md) if you want to contrbute to the Movie Recommender source code. Follow all the guidelines mentioned and raise a pull request for the developers to review before the code goes to the main source code.


Raise an issue on this repository, we would love to look at it ❤️
