%---------------------------write vtu file form x、y、z、value format data---------------------------------------%
%---------------------------    Ming Chen 0804.2022 Kiel ---------------------------------------%

function write2vtu(filename,vtux,vtuy,vtuz,vtuvalue)

% This is my matlab script for writting a vtu format file based on current
% matlab matrix data (x,y,z,v). vtu file can be open in Paraview
% Ming Chen, 20.04.2022, GEOMAR, Kiel
[zn,xn]=size(vtux);
Point_total=xn*zn;Cell_total=(xn-1)*(zn-1);

fid = fopen(filename,'wt');

fprintf(fid,'<VTKFile type="UnstructuredGrid" version="1.0" byte_oer="LittleEndian" header_type="UInt64">\n');
fprintf(fid,'  <UnstructuredGrid>\n');
fprintf(fid,'    <Piece NumberOfPoints="%d" NumberOfCells="%d">\n',Point_total,Cell_total);
%point data, for color
fprintf(fid,'      <PointData Scalars="DEM">\n');
fprintf(fid,'        <DataArray type="Float64" Name="Height" format="ascii">\n');
fprintf(fid,'          ');
for i=1:zn
    for j=1:xn
        fprintf(fid,'%f ',vtuz(i,j));
    end
end
fprintf(fid,'\n');
fprintf(fid,'        </DataArray>\n');
fprintf(fid,'        <DataArray type="Float64" Name="value" format="ascii">\n');
fprintf(fid,'          ');
for i=1:zn
    for j=1:xn
        fprintf(fid,'%f ',vtuvalue(i,j));
    end
end
fprintf(fid,'\n');
fprintf(fid,'        </DataArray>\n');
fprintf(fid,'      </PointData>\n');
fprintf(fid,'      <CellData>\n');
fprintf(fid,'      </CellData>\n');
fprintf(fid,'      <Points>\n');
fprintf(fid,'          <DataArray type="Float32" Name="Points" NumberOfComponents="3" format="ascii">\n');
for i=1:zn
    for j=1:xn
        fprintf(fid,'            %f %f %f\n',vtux(i,j),vtuy(i,j),vtuz(i,j));
    end
end
fprintf(fid,'          </DataArray>\n');
fprintf(fid,'      </Points>\n');
fprintf(fid,'      <Cells>\n');
fprintf(fid,'          <DataArray type="Int64" Name="connectivity" format="ascii">\n');
for i=1:zn-1
    for j=1:xn-1
        fprintf(fid,'            %d %d %d %d\n',(i-1)*xn+j-1,(i-1)*xn+j,(i-1)*xn+j+xn,(i-1)*xn+j+xn-1);
    end
end
fprintf(fid,'          </DataArray>\n');
fprintf(fid,'          <DataArray type="Int64" Name="offsets" format="ascii">\n');
fprintf(fid,'            ');
conn=0;
for i=1:Cell_total
        fprintf(fid,'%d ',conn);
        conn=conn+4;
end
fprintf(fid,'\n');
fprintf(fid,'          </DataArray>\n');
fprintf(fid,'          <DataArray type="UInt8" Name="types" format="ascii">\n');
fprintf(fid,'            ');
for i=1:Cell_total
        fprintf(fid,'%d ',9);   
end
fprintf(fid,'\n');
fprintf(fid,'          </DataArray>\n');
fprintf(fid,'      </Cells>\n');
fprintf(fid,'    </Piece>\n');
fprintf(fid,'  </UnstructuredGrid>\n');
fprintf(fid,'</VTKFile>\n');


fclose(fid)


end
