clear;clc

count=1000;


    % Temperature Plastic_Strain Phase
    
  %  field ='Temperature';
   % field ='StrainRate';
   % field= 'vx';
    %   field= 'PlasticStrain';
 % field= 'Temperature';
    save =5;
   
    
    xmin = -30;
    xmax = 30;
    zmin = -20;
    zmax = 4;
    rho = 3300;
    alpha = 3e-5;
    
    %==========================================================================
    %Loading the different fields
    if exist('plat9.64form.s','file') == 0
        plat = 'native';
    elseif exist('platform.s','file') == 2
        plat = 'ieee-le';
    end
    fid_t = fopen('time.0','r',plat);
    fid1 = fopen('vx.0','r',plat);
    fid2 = fopen('syy.0','r',plat);
    fid3 = fopen('aps.0','r',plat);
    fid4 = fopen('aps.0','r',plat);
    fid5 = fopen('temp.0','r',plat);
    fid6 = fopen('phas.0','r',plat);
    fid7 = fopen('srII.0','r',plat);

    loadflac;
   
    mkdir vtufile
   countmax=floor(max(t)/3600/24/365/1000/50);

for count=1:61
    
   
    istp=(count-1)*2+1;
   
    tsp = round(t(istp)/3600/24/365/1000);
    
    %==========================================================================
    for ii = 1:length(t)
        for jj = 1:nx
            %dZ = abs(diff([reshape(meshzz(1:end-1,jj,ii),ny,1);meshzz(1,jj,ii)+meshzz(end,1,1)]));
            dZ = -(diff([reshape(meshzz(1:end-1,jj,ii),ny,1);meshzz(1,jj,ii)+meshzz(end,1,1)]));
            drho = reshape(rho*(1-(alpha)*A4(:,jj,ii)),1,ny);
            tmass(jj) = drho*dZ*1e3;
        end
        zbox = meshzz(1,1,1)-meshzz(end,1,1);
        if tmass==0
            ziso(ii,:) = zeros(size(tmass));
        else
            ziso(ii,:) = zbox./(tmass./tmass(1))-zbox;
        end
    end
    
    kt=istp;
    a1=zeros(ny,nx);
    
    %==========================================================================
    %Computing arrays
    if istp > 3
        ma1 = (A1(:,:,kt-3) + A1(:,:,kt-2) + A1(:,:,kt-1) + A1(:,:,kt))./4;
        ma3 = (A3(:,:,kt-3) + A3(:,:,kt-2) + A3(:,:,kt-1) + A3(:,:,kt))./4;
        ma4 = (A4(:,:,kt-3) + A4(:,:,kt-2) + A4(:,:,kt-1) + A4(:,:,kt))./4;
        ma6 = (A6(:,:,kt-3) + A6(:,:,kt-2) + A6(:,:,kt-1) + A6(:,:,kt))./4;
        ma7 = (A7(:,:,kt-3) + A7(:,:,kt-2) + A7(:,:,kt-1) + A7(:,:,kt))./4;
    else
        ma1=A1(:,:,kt);ma3=A3(:,:,kt);ma4=A4(:,:,kt);ma6=A6(:,:,kt);ma7=A7(:,:,kt);
    end
    ma5 = A5(:,:,kt);
    xcnr=zeros(ny*nx,4); zcnr=xcnr;
    xcnr(:)=Xcnr(:,:,kt);  zcnr(:)=Zcnr(:,:,kt);
    
    vfac=6;qsize=1;
    jv=[1:vfac:nx]; iv=[1:vfac:ny];
    
    Vx=zeros([length(iv) length(jv)]); Vy=Vx; Xv=Vx; Yv=Vx;
    Vx(:)=vx(iv,jv,kt); Vy(:)=vz(iv,jv,kt);
    Xv(:)=meshxx(iv,jv,kt); Yv(:)=meshzz(iv,jv,kt);
    
    %==========================================================================
    %Plotting the selected field
    field= 'Phase';
    if strcmp(field,'PlasticStrain')
        ma = ma4;
    elseif strcmp(field,'Temperature')
        ma = ma5;
    elseif strcmp(field,'Phase')
        ma = ma6;
    elseif strcmp(field,'sxx')
        ma = ma1;
    elseif strcmp(field,'vx')
        ma = ma1;
    elseif strcmp(field,'StrainRate')
        ma = ma7;  
    end

  [xlen,zlen]=size(ma);

    cd vtufile;
    
        field1 ='StrainRate';
        filename1=strcat(field1,num2str(count+1000),'.vtu');
        xx=meshxx(1:xlen,1:zlen,kt);
        zz=meshzz(1:xlen,1:zlen,kt);
        vv=ones(size(xx));
        write2vtu(filename1,xx,zz,vv,ma7);
    
    field2 ='PlasticStrain';
    filename2=strcat(field2,num2str(count+1000),'.vtu');
    write2vtu(filename2,xx,zz,ones(size(xx)),ma4);
   
    field3 ='Temperature';
    filename3=strcat(field3,num2str(count+1000),'.vtu');
    write2vtu(filename3,xx,zz,ones(size(xx)),ma5);
    
    field4 ='Phase';
    filename4=strcat(field4,num2str(count+1000),'.vtu');
    write2vtu(filename4,xx,zz,ones(size(xx)),ma6);
    
     field5 ='Vector';
     filename5=strcat(field5,num2str(count+1000),'.vtu');
     write2vtuVector(filename5,Xv,Yv,Vx,Vy);

    cd ..;

end

meshxx(1,:,kt),meshzz(1,:,kt)

fid = fopen('seafloor_H08.txt','wt');
for j=1:211


        fprintf(fid,'%f %f\n',meshxx(1,j,kt),meshzz(1,j,kt));  %自动换行
 

end
fclose(fid)

