!============================================================================
! subroutine surf_move (tracer_move but for a chain of tracers)
! Move sedimentation surface every time step
! de Sagazan 6/18
!============================================================================

subroutine surf_move
include 'precision.inc'
include 'params.inc'
include 'arrays.inc'
integer k
real ynew
dimension elmt(4,5), dist(4,2), tab(4,2), triangle(3,1), anod(3,5)

do k=1,nesurf ! The surface is moved element by element

! Need to input element (i,j) AND
! Coordinates of tracer (xt,yt) at the beginning of the time step

i=el_surf(k,1)
j=el_surf(k,2)


! Coordinates and velocities on the nodes (useless here, but convenient to read...)

        x1 = cord(j  ,i  ,1)        !(x1,y1)         (x2,y2)
        y1 = cord(j  ,i  ,2)
        x2 = cord(j+1,i  ,1)        !(x3,y3)         (x4,y4)
        y2 = cord(j+1,i  ,2)
        x3 = cord(j  ,i+1,1)
        y3 = cord(j  ,i+1,2)
        x4 = cord(j+1,i+1,1)
        y4 = cord(j+1,i+1,2)
 
        ! Velocities:
        vx1 = vel(j  ,i  ,1)
        vy1 = vel(j  ,i  ,2)
        vx2 = vel(j+1,i  ,1)
        vy2 = vel(j+1,i  ,2)
        vx3 = vel(j  ,i+1,1)
        vy3 = vel(j  ,i+1,2)
        vx4 = vel(j+1,i+1,1)
        vy4 = vel(j+1,i+1,2)


! Storing this information in a matrix (elmt)


do ii=1,4
elmt(ii,1)=ii
end do

elmt(1,2)=cord(j  ,i  ,1)
elmt(1,3)=cord(j  ,i  ,2)
elmt(1,4)=vel(j  ,i  ,1)
elmt(1,5)=vel(j  ,i  ,2)
elmt(2,2)=cord(j+1,i  ,1)
elmt(2,3)=cord(j+1,i  ,2)
elmt(2,4)=vel(j+1,i  ,1)
elmt(2,5)=vel(j+1,i  ,2)
elmt(3,2)=cord(j  ,i+1,1)
elmt(3,3)=cord(j  ,i+1,2)
elmt(3,4)=vel(j  ,i+1,1)
elmt(3,5)=vel(j  ,i+1,2)
elmt(4,2)=cord(j+1,i+1,1)
elmt(4,3)=cord(j+1,i+1,2)
elmt(4,4)=vel(j+1,i+1,1)
elmt(4,5)=vel(j+1,i+1,2)




! computes a matrix (dist) with the distance from the tracer to each node
! to decide on which triangle to interpolate the velocities

do i=1,4
dist(i,1)=sqrt((coord_surf(k,1)-elmt(i,2))**2+(coord_surf(k,2)-elmt(i,3))**2)
dist(i,2)=i
end do


! sorting dist
temp1=0
temp3=0
tab=dist
do i=1,4
do j=i,4
if (tab(i,1).gt.tab(j,1)) then
temp1=tab(j,1)
temp3=tab(j,2)    
tab(j,1)=tab(i,1)
tab(j,2)=tab(i,2)  
tab(i,1)=temp1
tab(i,2)=temp3       
endif
enddo
enddo


! triangle is a vector containing the indexes of the nodes that will be used for interpolation
do pp=1,3
triangle(pp,1)=tab(pp,2)
end do

! sorting 'triangle', to place the nodes of the triangle counter-clockwise
temp2=0
do i=1,3
do j=i,3
if (triangle(i,1).gt.triangle(j,1)) then
temp2=triangle(j,1)
triangle(j,1)=triangle(i,1)
triangle(i,1)=temp2
endif
enddo
enddo


! anod features all the information on the actual nodes that will be used for interpolation

do i=1,3
anod(i,1)=i
anod(i,2:5)=elmt(triangle(i,1),2:5)
end do


!============================
! Interpolating (linearly)
!============================


! double area of the triangle
A2=(anod(2,2)*anod(3,3)-anod(3,2)*anod(2,3))+(anod(3,2)*anod(1,3)-anod(1,2)*anod(3,3)) &
+(anod(1,2)*anod(2,3)-anod(1,2)*anod(1,3))


! Interpolating x velocities

c1x=(1/A2)*(anod(1,4)*(anod(2,2)*anod(3,3)-anod(3,2)*anod(2,3)) &
+anod(2,4)*(anod(3,2)*anod(1,3)-anod(1,2)*anod(3,3)) &
+anod(3,4)*(anod(1,2)*anod(2,3)-anod(1,2)*anod(1,3)))
c2x=(1/A2)*(anod(1,4)*(anod(2,3)-anod(3,3))+anod(2,4)*(anod(3,3)-anod(1,3)) &
+anod(3,4)*(anod(1,3)-anod(2,3)))
c3x=(1/A2)*(anod(1,4)*(anod(3,2)-anod(2,2))+anod(2,4)*(anod(1,2)-anod(3,2)) &
+anod(3,4)*(anod(2,2)-anod(1,2)))

! Tracer velocity

vtx=c1x+c2x*coord_surf(k,1)+c3x*coord_surf(k,2)


! Interpolating y velocities

c1y=(1/A2)*(anod(1,5)*(anod(2,2)*anod(3,3)-anod(3,2)*anod(2,3)) &
+anod(2,5)*(anod(3,2)*anod(1,3)-anod(1,2)*anod(3,3)) &
+anod(3,5)*(anod(1,2)*anod(2,3)-anod(1,2)*anod(1,3)))
c2y=(1/A2)*(anod(1,5)*(anod(2,3)-anod(3,3))+anod(2,5)*(anod(3,3)-anod(1,3)) &
+anod(3,5)*(anod(1,3)-anod(2,3)))
c3y=(1/A2)*(anod(1,5)*(anod(3,2)-anod(2,2))+anod(2,5)*(anod(1,2)-anod(3,2)) &
+anod(3,5)*(anod(2,2)-anod(1,2)))

! Tracer velocity

vty=c1y+c2y*coord_surf(k,1)+c3y*coord_surf(k,2)



!============================
! Tracer Movement
!============================

!Checking the surface does not go berserk (it happens)
!If an element goes absurdly far, it is not moved
ynew=coord_surf(k,2)+vty*dt
if (abs(ynew-coord_surf(k,2)) .lt. 0.25*(maxval(coord_surf(:,2))-minval(coord_surf(:,2))) ) then
	coord_surf(k,1)=coord_surf(k,1)+vtx*dt
	coord_surf(k,2)=coord_surf(k,2)+vty*dt
end if

end do

end

